/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.service.versioning;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.jpa.service.AbstractJpaTest;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemResponseDto;
import org.qubership.atp.dataset.versioning.service.JaversHistoryService;
import org.qubership.atp.dataset.versioning.service.RestoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@Disabled
@Isolated
@SpringBootTest
@ContextConfiguration(classes={TestConfiguration.class})
@ExtendWith(value={SpringExtension.class})
public class VersioningRestoreTest
extends AbstractJpaTest {
    @Autowired
    protected DataSetListService queryDslDataSetListService;
    @Autowired
    protected RestoreService restoreService;
    @Autowired
    protected JaversHistoryService historyService;
    @Autowired
    protected DataSetService dsService;
    protected static ObjectMapper objectMapper = new ObjectMapper();
    UUID rootDataSetListId = UUID.fromString("f546d8c7-7486-4813-adab-8271a9df76f7");
    List<UUID> dataSetsToLock = new ArrayList<UUID>(Collections.singletonList(UUID.fromString("8bd4b9ee-4a26-4df1-bcc7-e72fd2ef673c")));
    List<UUID> paramsToDelete = new ArrayList<UUID>(Collections.singletonList(UUID.fromString("01da9b97-080d-4dbd-bbb7-a40fc1563dca")));
    List<UUID> textParamsToUpdate = new ArrayList<UUID>(Collections.singletonList(UUID.fromString("f6d23b9a-259b-49d0-8285-c5789c35a6ca")));
    List<UUID> dataSetsToRename = new ArrayList<UUID>(Collections.singletonList(UUID.fromString("8bd4b9ee-4a26-4df1-bcc7-e72fd2ef673c")));
    List<UUID> dataSetsToRemove = new ArrayList<UUID>();
    List<UUID> attributesToRemove = new ArrayList<UUID>();

    @Test
    @Sql(scripts={"classpath:test_data/sql/version_restore_test/versionRestorTest.sql"})
    public void createHistoryItem_lockDataSet_newFilledRowInHistory() throws Exception {
        int initialRevision = this.getCurrentRevision(this.rootDataSetListId);
        UUID dataSetUuidLock = null;
        Iterator<UUID> iterator = this.dataSetsToLock.iterator();
        while (iterator.hasNext()) {
            UUID dataSetId;
            dataSetUuidLock = dataSetId = iterator.next();
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetUuidLock), false);
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetUuidLock), true);
        }
        HistoryItemResponseDto allHistory = this.historyService.getAllHistory(this.rootDataSetListId, Integer.valueOf(0), Integer.valueOf(50));
        HistoryItemDto item = (HistoryItemDto)allHistory.getHistoryItems().get(0);
        Assertions.assertEquals((Object)"Unlocked", (Object)item.getOldValue());
        Assertions.assertEquals((Object)"Locked", (Object)item.getNewValue());
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/version_restore_test/versionRestorTest.sql"})
    public void restore_RestoreWithLockedDataSet_Exception() throws Exception {
        int initialRevision = this.getCurrentRevision(this.rootDataSetListId);
        UUID dataSetUuidLock = null;
        Iterator<UUID> iterator = this.dataSetsToLock.iterator();
        while (iterator.hasNext()) {
            UUID dataSetId;
            dataSetUuidLock = dataSetId = iterator.next();
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetUuidLock), false);
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetUuidLock), true);
        }
        HistoryItemResponseDto allHistory = this.historyService.getAllHistory(this.rootDataSetListId, Integer.valueOf(0), Integer.valueOf(50));
        try {
            this.restoreService.restore(this.rootDataSetListId, Integer.valueOf(allHistory.getHistoryItems().size() - 1));
        }
        catch (IllegalArgumentException iae) {
            Assertions.assertTrue((boolean)iae.getMessage().contains("Can not restore DSL"));
        }
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/version_restore_test/versionRestorTest.sql"})
    public void rename_createHistoryItem_newFilledRowInHistory() throws Exception {
        int initialRevision = this.getCurrentRevision(this.rootDataSetListId);
        String dataSetNewName = "Data Set 1 new name";
        Iterator<UUID> iterator = this.dataSetsToRename.iterator();
        while (iterator.hasNext()) {
            UUID dataSetId;
            UUID dataSetUuidWithNewName = dataSetId = iterator.next();
            this.dsService.rename(dataSetUuidWithNewName, dataSetNewName);
        }
        HistoryItemResponseDto allHistory = this.historyService.getAllHistory(this.rootDataSetListId, Integer.valueOf(0), Integer.valueOf(50));
        HistoryItemDto item = (HistoryItemDto)allHistory.getHistoryItems().get(0);
        Assertions.assertEquals((Object)item.getOldValue(), (Object)"Data Set 1");
        Assertions.assertEquals((Object)item.getNewValue(), (Object)dataSetNewName);
        this.restore(initialRevision);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/version_restore_test/versionRestorTest.sql"})
    public void createDslChangeAndRestore_TreesEqual() throws Exception {
        for (UUID dataSetId : this.dataSetsToLock) {
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetId), true);
            this.dataSetService.lock(this.rootDataSetListId, Collections.singletonList(dataSetId), false);
        }
        int initialRevision = this.getCurrentRevision(this.rootDataSetListId);
        UiManDataSetList firstRevision = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        this.removeAndUpdateParameters();
        UiManDataSetList revisionParamsUpdate = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        int paramsUpdateRevision = this.getCurrentRevision(this.rootDataSetListId);
        this.restore(initialRevision);
        UiManDataSetList restoredFirstRevision = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        Assertions.assertEquals((Object)this.treeToString(firstRevision), (Object)this.treeToString(restoredFirstRevision));
        this.restore(paramsUpdateRevision);
        UiManDataSetList restoredRevisionParamsUpdate = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        Assertions.assertEquals((Object)this.treeToString(revisionParamsUpdate), (Object)this.treeToString(restoredRevisionParamsUpdate));
        this.restore(initialRevision);
        for (UUID dataSetId : this.dataSetsToRemove) {
            this.dataSetService.remove(dataSetId);
        }
        UiManDataSetList revisionDsDeletion = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        UiManDataSetList revisionRestoredDsDeletion = this.queryDslDataSetListService.getAsTree(this.rootDataSetListId, false);
        Assertions.assertEquals((Object)this.treeToString(revisionDsDeletion), (Object)this.treeToString(revisionRestoredDsDeletion));
        this.restore(initialRevision);
        for (UUID attributeId : this.attributesToRemove) {
            this.attributeService.remove(attributeId);
        }
    }

    private int getCurrentRevision(UUID dataSetListId) {
        return this.historyService.getAllHistory(dataSetListId, Integer.valueOf(0), Integer.valueOf(100)).getHistoryItems().size();
    }

    private String treeToString(UiManDataSetList tree) throws JsonProcessingException {
        return objectMapper.writer().writeValueAsString((Object)tree);
    }

    @Transactional
    public void restore(int revision) {
        this.restoreService.restore(this.rootDataSetListId, Integer.valueOf(revision));
    }

    @Transactional
    public void removeAndUpdateParameters() {
        for (UUID parameterId : this.paramsToDelete) {
            this.parameterService.remove(parameterId);
        }
        for (UUID parameterId : this.textParamsToUpdate) {
            this.parameterService.updateParameter(parameterId, "Changed value", null, null);
        }
    }
}

