/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui.api;

import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQueryFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.AbstractNamed;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.ui.api.AbstractApiIntegrationCase;
import org.qubership.atp.dataset.ui.api.AttributePojo;
import org.qubership.atp.dataset.ui.api.ListValuePojo;
import org.springframework.beans.factory.annotation.Autowired;

@Isolated
public class AttributeITCase
extends AbstractApiIntegrationCase {
    @Autowired
    private SQLQueryFactory queryFactory;

    @Test
    public void getEagerByParentId_getAttributeListByDslId_VerifyThatOnlyOneSqlSelectWasExecuted() {
        TestData testData = this.createTestDataInstance(TestData::new);
        Mockito.reset((Object[])new SQLQueryFactory[]{this.queryFactory});
        List attributesActual = (List)baseUrl.path("/attribute/dsl").path(testData.ds.getDataSetList().getId().toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<AttributePojo>>(){});
        ((SQLQueryFactory)Mockito.verify((Object)this.queryFactory)).select((Expression[])ArgumentMatchers.any());
    }

    @Test
    public void getEagerByParentId_getAttributeListByDslId_CheckThatAttributesHasExpectedSortedListValues() {
        TestData testData = this.createTestDataInstance(TestData::new);
        Mockito.reset((Object[])new SQLQueryFactory[]{this.queryFactory});
        List attributesActual = (List)baseUrl.path("/attribute/dsl").path(testData.ds.getDataSetList().getId().toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get((GenericType)new GenericType<List<AttributePojo>>(){});
        List<AttributePojo> attributesExpected = this.getAttributePojosWithSortedListValues(testData);
        Assertions.assertEquals(attributesExpected, (Object)attributesActual);
    }

    private List<AttributePojo> getAttributePojosWithSortedListValues(TestData testData) {
        List<ListValuePojo> listValuePojos = testData.attr.getListValues().stream().map(ListValuePojo::convert).sorted(Comparator.comparing(AbstractNamed::getName)).collect(Collectors.toList());
        List<UUID> parametersUUIDs = testData.attr.getParameters().stream().map(Identified::getId).collect(Collectors.toList());
        AttributePojo attributePojo = new AttributePojo(testData.attr.getId(), testData.attr.getName(), testData.dsl.getId(), testData.attr.getType(), null, listValuePojos, parametersUUIDs);
        ArrayList<AttributePojo> attributePojos = new ArrayList<AttributePojo>();
        attributePojos.add(attributePojo);
        return attributePojos;
    }

    private static class TestData
    implements Supplier<VisibilityArea> {
        final VisibilityArea va;
        final DataSetList dsl;
        final DataSet ds;
        final Parameter param;
        final Attribute attr;

        TestData(CreationFacade create) {
            this.va = create.va("ATPII-4713");
            this.dsl = create.dsl(this.va, "DataSetList");
            this.ds = create.ds(this.dsl, "DataSet");
            this.attr = create.listAttr(this.dsl, "Attribute", new String[]{"selectedLV", "LV1", "LV2"});
            this.param = create.listParam(this.ds, this.attr, "selectedLV");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

