/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui.api;

import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.model.utils.AtpDsTestData;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.ui.api.AbstractApiIntegrationCase;

@Isolated
public class CopyDslITCase
extends AbstractApiIntegrationCase {
    @Test
    public void copyDsl_WithData_ContainsCopiesOfDs() {
        AtpDsTestData.ShuffleGroups data = this.createTestDataInstance(AtpDsTestData.ShuffleGroups::new);
        Response put = baseUrl.path("dsl/va").path(data.va.getId().toString()).path("dsl").path(data.dsl.getId().toString()).path("copy").queryParam("name", new Object[]{"Dsl Copy"}).queryParam("type", new Object[]{"true"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null);
        Assertions.assertSame((Object)Response.Status.OK, (Object)put.getStatusInfo().toEnum());
        UUID copyId = (UUID)put.readEntity(UUID.class);
        DataSetList copy = (DataSetList)this.dataSetListService.get(copyId);
        Assertions.assertNotNull((Object)copy);
        this.va = copy.getVisibilityArea();
        MatcherAssert.assertThat((Object)copy.getDataSets(), (Matcher)Matchers.hasSize((int)1));
        Parameter param2 = data.param2;
        FileData fileData = param2.getFileData();
        String url = fileData.getUrl();
        DataSet dataSet = (DataSet)copy.getDataSets().get(0);
        String urlOfCopiedFileVariable = ((Parameter)dataSet.getParameters().get(2)).getFileData().getUrl();
        Assertions.assertNotEquals((Object)url, (Object)urlOfCopiedFileVariable);
        copy.getDataSets().stream().flatMap(ds -> ds.getParameters().stream()).forEach(arg_0 -> ((ParameterService)this.parameterService).delete(arg_0));
    }

    @Test
    public void copyDsl_WithoutData_DoesntContainDses() {
        AtpDsTestData.ShuffleGroups data = this.createTestDataInstance(AtpDsTestData.ShuffleGroups::new);
        Response put = baseUrl.path("dsl/va").path(data.va.getId().toString()).path("dsl").path(data.dsl.getId().toString()).path("copy").queryParam("name", new Object[]{"Dsl Copy"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null);
        Assertions.assertSame((Object)Response.Status.OK, (Object)put.getStatusInfo().toEnum());
        UUID copyId = (UUID)put.readEntity(UUID.class);
        DataSetList copy = (DataSetList)this.dataSetListService.get(copyId);
        Assertions.assertNotNull((Object)copy);
        Assertions.assertTrue((boolean)copy.getDataSets().isEmpty());
    }
}

