/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui.api;

import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.ui.api.AbstractApiIntegrationCase;

@Isolated
public class CreateDslITCase
extends AbstractApiIntegrationCase {
    private VisibilityArea va;
    private TestPlan testPlan;

    @BeforeEach
    public void init() {
        this.va = this.factory.va("DslVa");
        this.testPlan = this.factory.testPlan(this.va, "TP");
    }

    @Test
    public void createDsl_withDslNameAndVaId_DslIsCreated() {
        Response put = baseUrl.path("dsl/va").path(this.va.getId().toString()).queryParam("name", new Object[]{"DSL1"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null);
        Assertions.assertSame((Object)Response.Status.CREATED, (Object)put.getStatusInfo().toEnum());
        UUID id = (UUID)put.readEntity(UUID.class);
        DataSetList dsl = (DataSetList)this.dataSetListService.get(id);
        Assertions.assertNotNull((Object)dsl);
        this.va = dsl.getVisibilityArea();
        MatcherAssert.assertThat((Object)this.va.getDataSetLists(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void createDsl_withDslNameAndVaIdAndTestPlan_DslIsCreated() {
        Response put = baseUrl.path("dsl/va").path(this.va.getId().toString()).queryParam("name", new Object[]{"DSL1"}).queryParam("testPlan", new Object[]{this.testPlan.getId().toString()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(null);
        Assertions.assertSame((Object)Response.Status.CREATED, (Object)put.getStatusInfo().toEnum());
        UUID id = (UUID)put.readEntity(UUID.class);
        DataSetList dsl = (DataSetList)this.dataSetListService.get(id);
        Assertions.assertNotNull((Object)dsl);
        this.va = dsl.getVisibilityArea();
        MatcherAssert.assertThat((Object)this.va.getDataSetLists(), (Matcher)Matchers.hasSize((int)1));
        Assertions.assertNotNull((Object)((DataSetList)this.va.getDataSetLists().get(0)).getTestPlan());
    }
}

