/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui.api;

import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.JsonMatcher;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.LabelProvider;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.ui.api.AbstractApiIntegrationCase;

@Isolated
public class GetByLabelITCase
extends AbstractApiIntegrationCase {
    @Test
    public void getDataSetLists_UsingLabel_GotOne() throws Exception {
        TestData data = this.createTestDataInstance(TestData::new);
        Invocation.Builder request = baseUrl.path("dsl/va").path(data.va.getId().toString()).queryParam("label", new Object[]{data.dslLabel.getName()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        String ar = (String)request.get(String.class);
        List<String> actual = this.getElements(ar);
        MatcherAssert.assertThat((Object)Response.Status.OK.getStatusCode(), (Matcher)Matchers.equalTo((Object)request.get().getStatus()));
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void getDataSetLists_UsingIllegalLabel_GotNothing() throws Exception {
        TestData data = this.createTestDataInstance(TestData::new);
        String er = "[]";
        String ar = (String)baseUrl.path("dsl/va").path(data.va.getId().toString()).queryParam("label", new Object[]{"Illegal"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
        MatcherAssert.assertThat((Object)ar, (Matcher)JsonMatcher.isMinified(er));
    }

    @Test
    public void getDataSets_UsingLabel_GotOne() throws Exception {
        TestData data = this.createTestDataInstance(TestData::new);
        String er = "[{  \"id\": \"" + data.dsWithLabel.getId() + "\",  \"name\": \"" + data.dsWithLabel.getName() + "\",  \"labels\": [{                  \"id\": \"" + data.dsLabel.getId() + "\",                  \"name\": \"" + data.dsLabel.getName() + "\"              }]}]";
        String ar = (String)baseUrl.path("dsl").path(data.dslNoLabel.getId().toString()).path("ds").queryParam("label", new Object[]{data.dsLabel.getName()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
        MatcherAssert.assertThat((Object)ar, (Matcher)JsonMatcher.isMinified(er));
    }

    @Test
    public void getDataSets_UsingIllegalLabel_GotNothing() throws Exception {
        TestData data = this.createTestDataInstance(TestData::new);
        String er = "[]";
        String ar = (String)baseUrl.path("dsl").path(data.dslNoLabel.getId().toString()).path("ds").queryParam("label", new Object[]{"Illegal"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
        MatcherAssert.assertThat((Object)ar, (Matcher)JsonMatcher.isMinified(er));
    }

    private static class TestData
    implements Supplier<VisibilityArea> {
        private final VisibilityArea va;
        private final DataSetList dslNoLabel;
        private final DataSetList dslWithLabel;
        private final Label dslLabel;
        private final DataSet dsNoLabel;
        private final DataSet dsWithLabel;
        private final Label dsLabel;

        public TestData(CreationFacade create) {
            this.va = create.va("ATPII-3262");
            this.dslNoLabel = create.dsl(this.va, "No label");
            this.dslWithLabel = create.dsl(this.va, "With label");
            this.dslLabel = create.label((LabelProvider)this.dslWithLabel, "Some Label");
            this.dsNoLabel = create.ds(this.dslNoLabel, "No label");
            this.dsWithLabel = create.ds(this.dslNoLabel, "With label");
            this.dsLabel = create.label((LabelProvider)this.dsWithLabel, "Some Label");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

