/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.controllers.api.dto.visibilityareas.VisibilityAreaFlatModelDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="VisibilityAreaController", description="Visibility Area Controller")
public interface VisibilityAreaControllerApi {
    @Operation(operationId="copyToVisibilityArea", summary="Copy DSL with name provided.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/va/{visibilityAreaId}/copyTo"}, consumes={"application/json"})
    public ResponseEntity<Void> copyToVisibilityArea(@Parameter(name="visibilityAreaId", description="visibilityAreaId", required=true) @PathVariable(value="visibilityAreaId") UUID var1, @Parameter(name="body", description="") @Valid @RequestBody(required=false) UUID var2);

    @Operation(operationId="create", summary="Creates new visibility area with provided name and order.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/va"}, produces={"application/json"})
    public ResponseEntity<UUID> create(@NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var1);

    @Operation(operationId="delete", summary="Deletes selected VA.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/va/{visibilityAreaId}"})
    public ResponseEntity<Void> delete(@Parameter(name="visibilityAreaId", description="visibilityAreaId", required=true) @PathVariable(value="visibilityAreaId") UUID var1);

    @Operation(operationId="getVisibilityAreas", summary="Returns all visibility areas.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=VisibilityAreaFlatModelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/va"}, produces={"application/json"})
    public ResponseEntity<List<VisibilityAreaFlatModelDto>> getVisibilityAreas();

    @Operation(operationId="getVisibilityAreasSorted", summary="Returns all visibility areas sorted by name.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=VisibilityAreaFlatModelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/va/sorted"}, produces={"application/json"})
    public ResponseEntity<List<VisibilityAreaFlatModelDto>> getVisibilityAreasSorted();

    @Operation(operationId="rename", summary="Renames selected VA.", tags={"visibility-area-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/va/{visibilityAreaId}"}, produces={"application/json"})
    public ResponseEntity<Boolean> rename(@Parameter(name="visibilityAreaId", description="visibilityAreaId", required=true) @PathVariable(value="visibilityAreaId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2);
}

