/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.impl.ListValueImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ListValueRepository
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final ListValuesProjection projection;
    private final Provider<AttributeRepository> attrRepo;
    private final Provider<ParameterRepository> paramRepo;
    private final CacheRepository cacheRepo;

    @Autowired
    public ListValueRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<AttributeRepository> attrRepo, @Nonnull Provider<ParameterRepository> paramRepo, @Nonnull CacheRepository cacheRepo) {
        this.queryFactory = queryFactory;
        this.attrRepo = attrRepo;
        this.paramRepo = paramRepo;
        this.cacheRepo = cacheRepo;
        this.projection = new ListValuesProjection(this);
    }

    @Nonnull
    public List<ListValue> create(@Nonnull UUID attributeId, @Nonnull List<String> values) {
        SQLInsertClause insert = this.queryFactory.insert((RelationalPath)LV);
        for (String value2 : values) {
            ((SQLInsertClause)insert.set(ListValueRepository.LV.attributeId, (Object)attributeId)).set((Path)ListValueRepository.LV.text, (Object)value2);
            insert.addBatch();
        }
        insert.setBatchToBulk(false);
        List ids = (List)Preconditions.checkNotNull((Object)insert.executeWithKeys(ListValueRepository.LV.id), (Object)"nothing created");
        Iterator id = ids.iterator();
        return values.stream().map(value -> this.projection.create((UUID)id.next(), attributeId, (String)value)).collect(Collectors.toList());
    }

    @Nonnull
    public ListValue create(@Nonnull UUID attributeId, @Nonnull String text) {
        SQLInsertClause insert = this.queryFactory.insert((RelationalPath)LV);
        ((SQLInsertClause)insert.set(ListValueRepository.LV.attributeId, (Object)attributeId)).set((Path)ListValueRepository.LV.text, (Object)text);
        UUID id = (UUID)Preconditions.checkNotNull((Object)((UUID)insert.executeWithKey(ListValueRepository.LV.id)));
        return this.projection.create(id, attributeId, text);
    }

    public boolean update(@Nonnull UUID id, @Nonnull String text) {
        return this.update((Predicate)ListValueRepository.LV.id.eq((Object)id), text) > 0L;
    }

    protected long update(@Nonnull Predicate predicate, @Nonnull String text) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)LV).where(predicate)).set((Path)ListValueRepository.LV.text, (Object)text)).execute();
    }

    @Nullable
    public ListValue getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(ListValue.class, id, uuid -> (ListValue)this.select((Predicate)ListValueRepository.LV.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(@Nonnull UUID id) {
        return this.cacheRepo.getIfPresent(ListValue.class, id) != null || this.select((Predicate)ListValueRepository.LV.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    List<ListValue> getByAttributeId(@Nonnull UUID attrId) {
        return ((SQLQuery)this.select((Predicate)ListValueRepository.LV.attributeId.eq((Object)attrId)).orderBy(ListValueRepository.LV.text.asc())).fetch();
    }

    @Nonnull
    public List<ListValue> getAll() {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)LV)).orderBy(ListValueRepository.LV.text.asc())).fetch();
    }

    @Nonnull
    protected SQLQuery<ListValue> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)LV)).where(predicate);
    }

    void onAttrDeleteCascade(@Nonnull UUID attributeId) {
        this.delete((Predicate)ListValueRepository.LV.attributeId.eq((Object)attributeId));
    }

    public boolean delete(@Nonnull UUID id) {
        ((ParameterRepository)this.paramRepo.get()).onListValueDeleteCascade(id);
        return this.delete((Predicate)ListValueRepository.LV.id.eq((Object)id)) > 0L;
    }

    protected long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)LV).where(predicate)).execute();
    }

    public boolean bulkDelete(@Nonnull List<UUID> ids) {
        ((ParameterRepository)this.paramRepo.get()).onListValuesDeleteCascade(ids);
        return this.delete((Predicate)ListValueRepository.LV.id.in(ids)) > 0L;
    }

    private class ListValuesProjection
    extends MappingProjection<ListValue> {
        private final ListValueRepository repo;

        ListValuesProjection(ListValueRepository repo) {
            super(ListValue.class, (Expression[])AbstractRepository.LV.all());
            this.repo = repo;
        }

        protected ListValue map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.LV.id);
            assert (id != null);
            UUID attributeId = (UUID)row.get(AbstractRepository.LV.attributeId);
            assert (attributeId != null);
            String contents = (String)row.get((Expression)AbstractRepository.LV.text);
            assert (contents != null);
            return this.create(id, attributeId, contents);
        }

        protected ListValue create(@Nonnull UUID id, @Nonnull UUID attributeId, @Nonnull String contents) {
            Attribute attr = Proxies.withId(Attribute.class, attributeId, uuid -> ((AttributeRepository)this.repo.attrRepo.get()).getById((UUID)uuid));
            return new ListValueImpl(id, attr, contents);
        }
    }
}

