/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa;

import java.util.List;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.dataset.db.jpa.JaversSnapshotService;
import org.qubership.atp.dataset.db.jpa.entities.JvSnapshotEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class JobRunner {
    private static final String UTC_TIMEZONE = "UTC";
    private final JaversSnapshotService javersSnapshotService;
    private final ThreadPoolTaskExecutor archiveJobExecutor;
    @Value(value="${atp-dataset.last.revision.count}")
    private Long lastRevisionCount;

    @Autowired
    public JobRunner(JaversSnapshotService javersSnapshotService, ThreadPoolTaskExecutor archiveJobExecutor) {
        this.javersSnapshotService = javersSnapshotService;
        this.archiveJobExecutor = archiveJobExecutor;
    }

    @Scheduled(cron="${atp-dataset.archive.cron.expression}", zone="UTC")
    @SchedulerLock(name="${atp-dataset.archive.job.name}", lockAtMostFor="12h", lockAtLeastFor="2h")
    public void run() {
        this.javersSnapshotService.deleteTerminatedSnapshots();
        this.javersSnapshotService.findGlobalIdAndCount(this.lastRevisionCount).stream().map(response -> () -> {
            Long globalId = response.getId();
            long numberOfOldSnapshots = response.getCount() - this.lastRevisionCount;
            List<JvSnapshotEntity> oldSnapshots = this.javersSnapshotService.findOldSnapshots(globalId, numberOfOldSnapshots);
            this.javersSnapshotService.deleteOldAndUpdateAsInitial(globalId, oldSnapshots);
        }).forEach(arg_0 -> ((ThreadPoolTaskExecutor)this.archiveJobExecutor).execute(arg_0));
    }
}

