/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.ei.service.DataSetAttributesImporter;
import org.qubership.atp.dataset.ei.service.DataSetFileImporter;
import org.qubership.atp.dataset.ei.service.DataSetListImporter;
import org.qubership.atp.dataset.ei.service.DataSetParametersImporter;
import org.qubership.atp.dataset.ei.service.DataSetsImporter;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.dto.validation.UserMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSetImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(DataSetImportExecutor.class);
    private final DataSetListImporter dataSetListImporter;
    private final DataSetsImporter dataSetsImporter;
    private final DataSetAttributesImporter dataSetAttributesImporter;
    private final DataSetParametersImporter dataSetParametersImporter;
    private final DataSetFileImporter dataSetFileImporter;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void importData(ExportImportData importData, Path workDir) throws Exception {
        log.info("start importData(importData: {}, workDir: {})", (Object)importData, (Object)workDir);
        this.dataSetListImporter.clearDuplicateNamesCache();
        List<UUID> dataSetLists = this.dataSetListImporter.importDataSetLists(workDir, importData);
        this.dataSetsImporter.importDataSets(workDir, importData);
        this.dataSetAttributesImporter.importDataSetAttributes(workDir, dataSetLists, importData);
        this.dataSetAttributesImporter.importDataSetAttributeKeys(workDir, importData);
        this.dataSetParametersImporter.importDataSetParameters(workDir, importData);
        this.dataSetFileImporter.importFiles(workDir, importData);
        log.info("end importData()");
        this.dataSetListImporter.clearDuplicateNamesCache();
    }

    @Transactional(readOnly=true)
    public ValidationResult preValidateData(ExportImportData exportImportData, Path path) throws Exception {
        return null;
    }

    @Transactional(readOnly=true)
    public ValidationResult validateData(ExportImportData importData, Path workDir) throws Exception {
        log.info("Start validate Data in path: {}", (Object)workDir);
        ArrayList details = new ArrayList();
        HashSet<String> messages = new HashSet<String>();
        HashMap<UUID, UUID> repMap = new HashMap<UUID, UUID>(importData.getReplacementMap());
        this.dataSetListImporter.clearDuplicateNamesCache();
        log.debug("[validateData]start handle import workDir: {} is new project:{} is interProject: {}", new Object[]{workDir, importData.isCreateNewProject(), importData.isInterProjectImport()});
        if (importData.isImportFirstTime()) {
            log.info("validate will be skipped, because isImportFirstTime = true");
        } else if (importData.isCreateNewProject()) {
            this.handleCreateNewProjectValidation(workDir, repMap);
        } else if (importData.isInterProjectImport()) {
            this.handleInterProjectImportValidation(workDir, messages, repMap);
        } else {
            this.handleImportInTheSameProjectValidation(workDir, messages, repMap);
        }
        if (CollectionUtils.isNotEmpty(messages)) {
            details.addAll(messages.stream().map(UserMessage::new).collect(Collectors.toList()));
        }
        this.dataSetListImporter.clearDuplicateNamesCache();
        return new ValidationResult(details, repMap);
    }

    private void handleImportInTheSameProjectValidation(Path workDir, Set<String> messages, Map<UUID, UUID> repMap) {
        messages.addAll(this.dataSetListImporter.validateDataSetLists(workDir, repMap, false));
        messages.addAll(this.dataSetsImporter.validateDataSets(workDir, repMap, false));
        messages.addAll(this.dataSetAttributesImporter.validateDataSetAttributes(workDir, repMap, false));
        messages.addAll(this.dataSetParametersImporter.validateDataSetParameters(workDir, repMap, false));
    }

    private void handleInterProjectImportValidation(Path workDir, Set<String> messages, Map<UUID, UUID> repMap) {
        this.dataSetListImporter.fillRepMapWithSourceTargetValues(repMap, workDir);
        this.dataSetsImporter.fillRepMapWithSourceTargetValues(repMap, workDir);
        this.dataSetAttributesImporter.fillRepMapWithSourceTargetValues(repMap, workDir);
        this.dataSetParametersImporter.fillRepMapWithSourceTargetValues(repMap, workDir);
        repMap.entrySet().forEach(entry -> {
            if (entry.getValue() == null) {
                entry.setValue(UUID.randomUUID());
            }
        });
        messages.addAll(this.dataSetListImporter.validateDataSetLists(workDir, repMap, true));
        messages.addAll(this.dataSetsImporter.validateDataSets(workDir, repMap, true));
        messages.addAll(this.dataSetAttributesImporter.validateDataSetAttributes(workDir, repMap, true));
        messages.addAll(this.dataSetParametersImporter.validateDataSetParameters(workDir, repMap, true));
    }

    private void handleCreateNewProjectValidation(Path workDir, Map<UUID, UUID> repMap) {
        ArrayList<UUID> allIds = new ArrayList<UUID>();
        allIds.addAll(this.dataSetListImporter.getDslIds(workDir));
        allIds.addAll(this.dataSetsImporter.getDsIds(workDir));
        allIds.addAll(this.dataSetAttributesImporter.getDsAttributeIds(workDir));
        allIds.addAll(this.dataSetAttributesImporter.getDsAttributeKeysIds(workDir));
        allIds.addAll(this.dataSetAttributesImporter.getDsListValuesIds(workDir));
        allIds.addAll(this.dataSetParametersImporter.getDsParameterIds(workDir));
        allIds.forEach(id -> repMap.put((UUID)id, UUID.randomUUID()));
    }

    public DataSetImportExecutor(DataSetListImporter dataSetListImporter, DataSetsImporter dataSetsImporter, DataSetAttributesImporter dataSetAttributesImporter, DataSetParametersImporter dataSetParametersImporter, DataSetFileImporter dataSetFileImporter) {
        this.dataSetListImporter = dataSetListImporter;
        this.dataSetsImporter = dataSetsImporter;
        this.dataSetAttributesImporter = dataSetAttributesImporter;
        this.dataSetParametersImporter = dataSetParametersImporter;
        this.dataSetFileImporter = dataSetFileImporter;
    }
}

