/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.args.RefArg;
import org.qubership.atp.dataset.macros.cache.Cache;
import org.qubership.atp.dataset.macros.cache.CachedParameter;
import org.qubership.atp.dataset.macros.cache.MacroCacheKey;
import org.qubership.atp.dataset.macros.cache.NoCache;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.impl.reference.ReferenceAliasType;
import org.qubership.atp.dataset.macros.processor.MacroContext;
import org.qubership.atp.dataset.macros.processor.MacroProcessorImpl;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;

public class EvalContextImpl
implements EvaluationContext {
    public static final Comparator<EvalContextImpl> SAME_NON_STRICT = Comparator.comparing(ctx -> ctx.getDs().getId());
    private static final String ALL_CONTEXTS_TRIED = "All contexts are tried.";
    protected final MacroRegistry registry;
    protected final AliasWrapperService wrapperService;
    protected final Cache cache;
    private final EvalContextImpl root;
    private final EvalContextImpl parent;
    private final DataSetList dsl;
    private final DataSet ds;
    private final List<Attribute> pathFromParent;
    private final boolean parentIsStrict;
    private final Attribute targetAttrFromParent;
    private Function<String, String> debugIdentifier = AppendDebugIdentifier.access$000();

    public EvalContextImpl(@Nullable EvalContextImpl parent, @Nonnull MacroRegistry registry, @Nonnull AliasWrapperService wrapperService, @Nonnull Cache cache, @Nonnull DataSetList dsl, @Nonnull DataSet ds, boolean parentIsStrict, @Nonnull List<Attribute> pathFromParent, @Nullable Attribute targetAttrFromParent) {
        this.parent = parent;
        this.registry = registry;
        this.wrapperService = wrapperService;
        this.cache = cache;
        this.dsl = dsl;
        this.ds = ds;
        this.pathFromParent = pathFromParent;
        this.parentIsStrict = parentIsStrict;
        this.targetAttrFromParent = targetAttrFromParent;
        this.root = parent == null ? this : parent.getRoot();
    }

    private static <O> O executeInContext(@Nonnull EvaluationContext context, @Nonnull MacroContext.ContextedTask<O> toExecute) throws Exception {
        try {
            return toExecute.apply(context);
        }
        catch (Exception e) {
            throw new Exception("Operation failed; context used: " + context, e);
        }
    }

    @Nonnull
    private static <T extends Identified & Named> T resolveUsingCtx(@Nonnull List<? extends RefArg<?>> previousArgs, @Nonnull RefArg<T> arg, @Nonnull EvaluationContext context) throws Exception {
        try {
            Optional<RefArg.Signature<T>> sigOpt = arg.asSignature();
            if (!sigOpt.isPresent()) {
                RefArg.Context<T> ctx = arg.asContextRef().orElseThrow(() -> new IllegalArgumentException("Expected to be context ref: " + arg));
                return ctx.resolve(context);
            }
            RefArg.Signature<T> sig = sigOpt.get();
            return sig.resolve(previousArgs, context.getDsl().getVisibilityArea(), context.getDsl());
        }
        catch (Exception e) {
            throw new Exception("Can not resolve argument [" + arg + "]", e);
        }
    }

    @Override
    @Nullable
    public EvalContextImpl getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public DataSetList getDsl() {
        return this.dsl;
    }

    @Override
    @Nonnull
    public DataSet getDs() {
        return this.ds;
    }

    @Override
    @Nonnull
    public EvalContextImpl getRoot() {
        return this.root;
    }

    @Override
    @Nonnull
    public String evaluate(@Nonnull OverlapItem.Reachable source, @Nonnull Parameter target, @Nonnull String value) throws CtxEvalException {
        UUID sourceId = source.getSourceDs().getId();
        MacroCacheKey cacheKey = this.cache.newKey(new CachedParameter(target, sourceId, source.getUuidPath()));
        String cachedValue = cacheKey.lookupValue();
        if (cachedValue == null) {
            cachedValue = this.createChild(source, target).evaluate(value, cacheKey);
        }
        return cachedValue;
    }

    @Override
    @Nonnull
    public String evaluate(@Nonnull String inputText) throws CtxEvalException {
        return this.evaluate(inputText, NoCache.KEY);
    }

    @Nonnull
    protected String evaluate(@Nonnull String inputText, @Nonnull MacroCacheKey cacheKey) throws CtxEvalException {
        Preconditions.checkArgument((!inputText.isEmpty() ? 1 : 0) != 0, (Object)"Input should not be empty");
        MacroProcessorImpl macroProcessor = new MacroProcessorImpl(this, this.registry, this.wrapperService, inputText, cacheKey);
        this.debugIdentifier = str -> macroProcessor + " " + str;
        return macroProcessor.evaluateAll();
    }

    @Override
    @Nonnull
    public String evaluate(@Nonnull Parameter parameter, @Nonnull String value) throws CtxEvalException {
        MacroCacheKey cacheKey = this.cache.newKey(parameter);
        String cachedValue = cacheKey.lookupValue();
        if (cachedValue != null) {
            return cachedValue;
        }
        return this.evaluate(value, cacheKey);
    }

    @Override
    @Nonnull
    public List<RefArg<Attribute>> relativizePathFromSharedToThis(@Nonnull EvaluationContext shared, @Nonnull List<RefArg<Attribute>> attrArgs) {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        EvalContextImpl current = this;
        while (true) {
            assert (current != null);
            result.addAll(0, current.pathFromParent);
            if (shared.equals(current)) break;
            current = current.getParent();
        }
        if (result.isEmpty()) {
            return attrArgs;
        }
        return Stream.concat(result.stream().map(attr -> RefArg.of(ReferenceAliasType.ATTR, attr)), attrArgs.stream()).collect(Collectors.toList());
    }

    @Nonnull
    protected EvalContextImpl createChild(@Nonnull OverlapItem.Reachable source, @Nonnull Parameter target) {
        DataSet sourceDs = source.getSourceDs();
        if (this.getDs().equals(sourceDs)) {
            List<Attribute> pathFromSourceDs;
            if (target.isOverlap()) {
                List<Attribute> tail = target.asOverlap().getAttributePath().getPath();
                pathFromSourceDs = new ArrayList<Attribute>(source.getFoundByAttrPath().size() + tail.size());
                pathFromSourceDs.addAll(source.getFoundByAttrPath());
                pathFromSourceDs.addAll(tail);
            } else {
                pathFromSourceDs = source.getFoundByAttrPath();
            }
            if (this.pathFromParent.equals(pathFromSourceDs)) {
                return this;
            }
            return this.createChild(sourceDs.getDataSetList(), sourceDs, true, pathFromSourceDs, target.getAttribute());
        }
        DataSet targetDs = source.getTargetDs();
        return this.createChild(targetDs.getDataSetList(), targetDs, false, Collections.emptyList(), target.getAttribute());
    }

    @Nonnull
    protected EvalContextImpl createChild(@Nonnull DataSetList dsl, @Nonnull DataSet ds, boolean parentIsStrict, @Nonnull List<Attribute> pathFromParent, @Nonnull Attribute targetAttrFromParent) {
        return new EvalContextImpl(this, this.registry, this.wrapperService, this.cache, dsl, ds, parentIsStrict, pathFromParent, targetAttrFromParent);
    }

    @Override
    @Nonnull
    public <O> O executeInAnyContext(@Nonnull Iterator<? extends EvaluationContext> of, @Nonnull MacroContext.ContextedTask<O> toExecute) throws CtxEvalException {
        LinkedList<Exception> errors = null;
        while (of.hasNext()) {
            EvaluationContext ctx = of.next();
            try {
                O result = EvalContextImpl.executeInContext(ctx, toExecute);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new LinkedList<Exception>();
                }
                errors.add(e);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw new CtxEvalException(ALL_CONTEXTS_TRIED, this, (Throwable)errors.iterator().next());
            }
            CtxEvalException toThrow = new CtxEvalException(ALL_CONTEXTS_TRIED, this);
            errors.forEach(toThrow::addSuppressed);
            throw toThrow;
        }
        throw new NullPointerException("No value provided");
    }

    @Override
    public void resolveArguments(@Nonnull List<? extends RefArg<?>> args) throws Exception {
        for (int i = 0; i < args.size(); ++i) {
            RefArg<?> toResolve = args.get(i);
            List<? extends RefArg<?>> previousArgs = args.subList(0, i);
            EvalContextImpl.resolveUsingCtx(previousArgs, toResolve, this);
        }
    }

    public String toString() {
        StringBuilder thisStr = new StringBuilder("#context: DSL [").append(this.ds.getDataSetList().getName()).append("]; DS [").append(this.ds.getName()).append("]");
        if (!this.pathFromParent.isEmpty()) {
            thisStr.append("; Relative path [").append(this.pathFromParent.stream().map(Named::getName).collect(Collectors.joining("."))).append("]; Target attr [").append(this.targetAttrFromParent.getName()).append("]");
        }
        return this.debugIdentifier.apply(thisStr.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalContextImpl that = (EvalContextImpl)o;
        return Objects.equals(this.getDs(), that.getDs()) && Objects.equals(this.pathFromParent, that.pathFromParent) && this.parentIsStrict == that.parentIsStrict;
    }

    public int hashCode() {
        return Objects.hash(this.getDs(), this.pathFromParent, this.parentIsStrict);
    }

    @Nonnull
    public Iterator<EvalContextImpl> getStrictContexts() {
        return new AbstractIterator<EvalContextImpl>(){
            private EvalContextImpl next;
            {
                this.next = EvalContextImpl.this;
            }

            protected EvalContextImpl computeNext() {
                if (this.next == null) {
                    return (EvalContextImpl)this.endOfData();
                }
                EvalContextImpl result = this.next;
                this.next = result.parentIsStrict ? result.getParent() : null;
                return result;
            }
        };
    }

    @Nonnull
    public Iterator<EvalContextImpl> getNonStrictContexts() {
        return new AbstractIterator<EvalContextImpl>(){
            private final TreeSet<EvalContextImpl> checked = new TreeSet<EvalContextImpl>(SAME_NON_STRICT);
            private EvalContextImpl next = EvalContextImpl.this;
            private boolean isStrict = true;

            protected EvalContextImpl computeNext() {
                while (this.next != null && (this.isStrict && this.next.pathFromParent.isEmpty() || this.checked.contains(this.next))) {
                    this.isStrict = this.next.parentIsStrict;
                    this.next = this.next.getParent();
                }
                if (this.next == null) {
                    return (EvalContextImpl)this.endOfData();
                }
                EvalContextImpl result = this.next;
                this.checked.add(result);
                this.next = result.getParent();
                return result;
            }
        };
    }

    private static class AppendDebugIdentifier
    implements Function<String, String> {
        private static AppendDebugIdentifier INSTANCE = new AppendDebugIdentifier();

        private AppendDebugIdentifier() {
        }

        @Override
        public String apply(String s) {
            return s;
        }

        static /* synthetic */ AppendDebugIdentifier access$000() {
            return INSTANCE;
        }
    }
}

