/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.utils.tree.TraverseVisitor;

public abstract class AbstractDsUiHandler
implements TraverseVisitor<DataSet, Attribute> {
    private final DslVisitor dslH = new DslVisitor();
    private final AttrVisitor attrH = new AttrVisitor();
    protected DataSet curDs;
    protected DataSetList curDsl;
    protected Attribute curAttr;
    protected int dslDepth = 0;

    protected void attributeStarts(Attribute attr) {
        this.curAttr = attr;
    }

    protected void goForwardUnderAttribute() {
    }

    protected void goBackFromAttribute() {
    }

    protected void attributeEnds() {
    }

    @Override
    @Nullable
    protected Iterator<? extends DataSetList> getChildren(@Nonnull Attribute item) {
        if (item.getType() == AttributeType.DSL) {
            return item.getDataSetListReference() == null ? null : Iterators.singletonIterator((Object)item.getDataSetListReference());
        }
        return null;
    }

    @Override
    @Nullable
    protected Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
        return item.getAttributes().iterator();
    }

    @Override
    @Nullable
    public Iterator<? extends Attribute> getChildren(@Nonnull DataSet item) {
        return this.getChildren(item.getDataSetList());
    }

    protected void dslStarts(DataSetList dsl) {
        this.curDsl = dsl;
    }

    protected void goForwardUnderDsl() {
        ++this.dslDepth;
    }

    protected void goBackFromDsl() {
        --this.dslDepth;
    }

    protected void dslEnds() {
    }

    @Override
    public void notifyItemStarts(DataSet item) {
        this.curDs = item;
        this.dslStarts(item.getDataSetList());
    }

    @Override
    public void notifyProcessingChildren() {
        this.goForwardUnderDsl();
    }

    @Override
    public void notifyChildrenProcessed() {
        this.goBackFromDsl();
    }

    @Override
    public void notifyItemEnds() {
        this.dslEnds();
    }

    @Override
    @Nonnull
    public TraverseVisitor<?, DataSet> backToPreviousParent() {
        throw new UnsupportedOperationException("Unsupported since data set is root and has no parent");
    }

    @Override
    @Nonnull
    public TraverseVisitor<Attribute, ?> forwardToNewParent(@Nonnull DataSet parent) {
        return this.dslH.forwardToNewParent(parent.getDataSetList());
    }

    private class DslVisitor
    implements TraverseVisitor<DataSetList, Attribute> {
        private DslVisitor() {
        }

        @Override
        public void notifyItemStarts(DataSetList item) {
            AbstractDsUiHandler.this.dslStarts(item);
        }

        @Override
        public void notifyProcessingChildren() {
            AbstractDsUiHandler.this.goForwardUnderDsl();
        }

        @Override
        public void notifyChildrenProcessed() {
            AbstractDsUiHandler.this.goBackFromDsl();
        }

        @Override
        public void notifyItemEnds() {
            AbstractDsUiHandler.this.dslEnds();
        }

        @Override
        @Nonnull
        public TraverseVisitor<?, DataSetList> backToPreviousParent() {
            return AbstractDsUiHandler.this.attrH;
        }

        @Override
        @Nonnull
        public TraverseVisitor<Attribute, ?> forwardToNewParent(@Nonnull DataSetList parent) {
            return AbstractDsUiHandler.this.attrH;
        }

        @Override
        @Nullable
        public Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
            return AbstractDsUiHandler.this.getChildren(item);
        }
    }

    private class AttrVisitor
    implements TraverseVisitor<Attribute, DataSetList> {
        private AttrVisitor() {
        }

        @Override
        public void notifyItemStarts(Attribute item) {
            AbstractDsUiHandler.this.attributeStarts(item);
        }

        @Override
        public void notifyProcessingChildren() {
            AbstractDsUiHandler.this.goForwardUnderAttribute();
        }

        @Override
        public void notifyChildrenProcessed() {
            AbstractDsUiHandler.this.goBackFromAttribute();
        }

        @Override
        public void notifyItemEnds() {
            AbstractDsUiHandler.this.attributeEnds();
        }

        @Override
        @Nonnull
        public TraverseVisitor<?, Attribute> backToPreviousParent() {
            if (AbstractDsUiHandler.this.dslDepth == 0) {
                return AbstractDsUiHandler.this;
            }
            return AbstractDsUiHandler.this.dslH;
        }

        @Override
        @Nonnull
        public TraverseVisitor<DataSetList, ?> forwardToNewParent(@Nonnull Attribute parent) {
            return AbstractDsUiHandler.this.dslH;
        }

        @Override
        @Nullable
        public Iterator<? extends DataSetList> getChildren(@Nonnull Attribute item) {
            return AbstractDsUiHandler.this.getChildren(item);
        }
    }
}

