/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.javers.common.string.Strings;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.db.ListValueRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.jpa.entities.AttributesSortType;
import org.qubership.atp.dataset.db.jpa.entities.UserSettingsEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributesSortEnabledRepository;
import org.qubership.atp.dataset.exception.attribute.AttributeTypeException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttributeServiceImpl
implements AttributeService {
    private static final Logger log = LoggerFactory.getLogger(AttributeServiceImpl.class);
    private static final String multiplyPrefix = "MULTIPLY";
    private final ListValueRepository listValueRepository;
    private final AttributeRepository attributeRepository;
    private final ParameterRepository parameterRepository;
    private final Provider<DataSetListService> dslServiceProvider;
    private final ObjectMapper mapper;
    private final DateAuditorService dateAuditorService;
    private final DataSetListSnapshotService dataSetListSnapshotService;
    private final JpaAttributesSortEnabledRepository jpaAttributesSortEnabledRepository;
    private final ClearCacheService clearCacheService;

    @Autowired
    public AttributeServiceImpl(ListValueRepository listValueRepository, AttributeRepository attributeRepository, Provider<DataSetListService> dslServiceProvider, ObjectMapper mapper, DateAuditorService dateAuditorService, DataSetListSnapshotService dataSetListSnapshotService, ParameterRepository parameterRepository, JpaAttributesSortEnabledRepository jpaAttributesSortEnabledRepository, ClearCacheService clearCacheService) {
        this.listValueRepository = listValueRepository;
        this.attributeRepository = attributeRepository;
        this.dslServiceProvider = dslServiceProvider;
        this.mapper = mapper;
        this.dateAuditorService = dateAuditorService;
        this.dataSetListSnapshotService = dataSetListSnapshotService;
        this.parameterRepository = parameterRepository;
        this.jpaAttributesSortEnabledRepository = jpaAttributesSortEnabledRepository;
        this.clearCacheService = clearCacheService;
    }

    @Override
    @Transactional
    @Nonnull
    public Attribute create(@Nonnull UUID dslId, @Nonnull Integer order, @Nonnull String name, @Nonnull AttributeType type, @Nullable UUID dslRefId, @Nullable List<String> listValues) {
        Attribute attribute = this.attributeRepository.create(dslId, order, name, type, dslRefId, listValues);
        this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
        this.dataSetListSnapshotService.commitEntity(dslId);
        return attribute;
    }

    @Override
    @Transactional
    public boolean updateTypeDslId(@Nonnull UUID dslId, UUID id) {
        return this.attributeRepository.updateTypeDslId(dslId, id);
    }

    @Override
    @Transactional
    public boolean update(@Nonnull UUID id, @Nonnull String name) {
        boolean isUpdated;
        Attribute attribute = this.attributeRepository.getById(id);
        boolean bl = isUpdated = attribute != null && this.attributeRepository.update(id, name);
        if (isUpdated) {
            this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
            this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        }
        return isUpdated;
    }

    @Override
    @Transactional
    public boolean updateDslReference(@Nonnull UUID id, @Nonnull UUID dslReferenceId) {
        Attribute attribute = this.attributeRepository.getById(id);
        Preconditions.checkNotNull((Object)attribute, (Object)("Attribute with id " + id + " not found."));
        Preconditions.checkArgument((boolean)attribute.getType().equals((Object)AttributeType.DSL), (Object)"Referenced DSL can be updated only for attributes of DSL type.");
        List<DataSet> dataSets = attribute.getDataSetList().getDataSets();
        HashSet<UUID> attrRefsForOverlaps = new HashSet<UUID>();
        this.collectAttributesForOverlapDelete(attribute, attrRefsForOverlaps);
        HashSet paramsToDelete = new HashSet();
        for (DataSet ds : dataSets) {
            this.clearCacheService.evictDatasetListContextCache(ds.getId());
            paramsToDelete.addAll(ds.getParameters().stream().filter(param -> param.getAttribute().getId().equals(attribute.getId()) || param instanceof ParameterOverlap && ((ParameterOverlap)param).getAttributePath().getPath().stream().anyMatch(attr -> attr.getId().equals(attribute.getId()))).collect(Collectors.toSet()));
        }
        this.parameterRepository.deleteOverlaps(attribute.getId(), attributePath -> true);
        attrRefsForOverlaps.forEach(attrId -> this.parameterRepository.deleteOverlaps((UUID)attrId, attrPath -> attrPath.getPath().stream().anyMatch(attr1 -> attr1.getId().equals(attribute.getId()))));
        paramsToDelete.forEach(this.parameterRepository::delete);
        return this.attributeRepository.updateDslRef(id, dslReferenceId);
    }

    @NotNull
    private void collectAttributesForOverlapDelete(Attribute attribute, Set<UUID> attrIds) {
        if (attribute.getDataSetListReference() == null) {
            attrIds.add(attribute.getId());
        } else {
            attribute.getDataSetListReference().getAttributes().forEach(attr -> {
                attrIds.add(attr.getId());
                this.collectAttributesForOverlapDelete((Attribute)attr, attrIds);
            });
        }
    }

    @Override
    @Nullable
    public Object getOptions(@Nonnull UUID id) {
        Attribute attribute = this.get(id);
        if (attribute == null) {
            return null;
        }
        switch (attribute.getType()) {
            case LIST: {
                return attribute.getListValues();
            }
            case DSL: 
            case CHANGE: {
                DataSetList dataSetList = attribute.getDataSetListReference();
                Preconditions.checkNotNull((Object)dataSetList, (String)"Attribute [%s] should have data set reference", (Object)attribute);
                UiManDataSetList result = new UiManDataSetList();
                result.setSource(dataSetList);
                List<DataSet> dataSets = dataSetList.getDataSets();
                dataSets.sort(Comparator.comparing(Named::getName));
                for (DataSet dataSet : dataSets) {
                    UiManDataSet converted = new UiManDataSet();
                    converted.setSource(dataSet);
                    result.getDataSets().add(converted);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<Attribute> getByDslId(@Nonnull UUID dslId) {
        return this.attributeRepository.getEagerByParentId(dslId);
    }

    @Override
    @Nullable
    public ArrayNode getByDslIdInItfFormat(@Nonnull UUID dslId) {
        DataSetList dataSetList = (DataSetList)((DataSetListService)this.dslServiceProvider.get()).get(dslId);
        if (dataSetList == null) {
            return null;
        }
        return Utils.serializeAttrInItfWay(dataSetList, this.mapper);
    }

    @Override
    @Nullable
    public Attribute get(@Nonnull UUID id) {
        return this.attributeRepository.getById(id);
    }

    @Override
    public boolean existsById(@NotNull UUID id) {
        return this.attributeRepository.existsById(id);
    }

    @Override
    @Nonnull
    public List<Attribute> getAll() {
        return this.attributeRepository.getAll();
    }

    @Override
    @Transactional
    public boolean delete(@Nonnull UUID id) {
        Attribute attribute = this.attributeRepository.getById(id);
        boolean isDeleted = this.attributeRepository.delete(id);
        if (isDeleted && attribute != null) {
            attribute.getParameters().forEach(param -> this.clearCacheService.evictDatasetListContextCache(param.getDataSet().getId()));
            this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
            this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        }
        return isDeleted;
    }

    @Override
    @Transactional
    @Nonnull
    public ListValue createListValue(@Nonnull UUID attributeId, @Nonnull String value) {
        ListValue listValue = this.listValueRepository.create(attributeId, value);
        Attribute attribute = this.get(attributeId);
        if (attribute != null) {
            this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
        }
        this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        return listValue;
    }

    @Override
    @Transactional
    @Nonnull
    public List<UUID> createListValues(@Nonnull UUID attributeId, @Nonnull List<String> values) {
        ArrayList<UUID> listValuesIds = new ArrayList<UUID>();
        for (String value : values) {
            listValuesIds.add(this.listValueRepository.create(attributeId, value).getId());
        }
        Attribute attribute = this.get(attributeId);
        if (attribute != null) {
            this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
            this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
        }
        return listValuesIds;
    }

    @Override
    @Transactional
    public boolean deleteListValue(@Nonnull UUID attributeId, @Nonnull UUID listValueId) {
        Attribute attribute = this.get(attributeId);
        boolean isDeleted = false;
        if (Objects.nonNull(attribute)) {
            attribute.getParameters().forEach(param -> {
                if (param.getListValue().getId().equals(listValueId)) {
                    this.clearCacheService.evictParameterCache(param.getId());
                    this.clearCacheService.evictDatasetListContextCache(param.getDataSet().getId());
                }
            });
            this.checkUsedValueLockDs(attributeId, listValueId);
            isDeleted = this.listValueRepository.delete(listValueId);
            if (isDeleted) {
                this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
            }
        }
        return isDeleted;
    }

    @Override
    @Transactional
    public boolean deleteListValues(UUID attributeId, @Nonnull List<UUID> ids) {
        Attribute attribute = this.get(attributeId);
        boolean isDeleted = false;
        if (Objects.nonNull(attribute)) {
            attribute.getParameters().forEach(param -> {
                this.clearCacheService.evictParameterCache(param.getId());
                this.clearCacheService.evictDatasetListContextCache(param.getDataSet().getId());
            });
            ids.forEach(iterListValueId -> this.checkUsedValueLockDs(attributeId, (UUID)iterListValueId));
            isDeleted = this.listValueRepository.bulkDelete(ids);
            if (isDeleted) {
                this.dateAuditorService.updateModifiedFields(attribute.getDataSetList().getId());
                this.dataSetListSnapshotService.commitEntity(attribute.getDataSetList().getId());
            }
        }
        return isDeleted;
    }

    private void checkUsedValueLockDs(@NotNull UUID attributeId, @NotNull UUID listValueId) {
        List<Parameter> parameters = this.parameterRepository.getByAttributeId(attributeId);
        parameters.forEach(parameter -> {
            ListValue parameterListValue = parameter.getListValue();
            if (Objects.nonNull(parameterListValue) && listValueId.equals(parameterListValue.getId())) {
                DataSet dataSet = parameter.getDataSet();
                Preconditions.checkArgument((dataSet.isLocked() == false ? 1 : 0) != 0, (String)"Can not change list value(s) with attribute name: '%s' and dataSet name: '%s', id: %s because dataset locked", (Object)parameterListValue.getAttribute().getName(), (Object)dataSet.getName(), (Object)dataSet.getId());
            }
        });
    }

    @Override
    public Attribute copy(@Nonnull DataSetList newParentDsl, @Nonnull Attribute attribute, int ordering) {
        Attribute result;
        UUID dslId = newParentDsl.getId();
        switch (attribute.getType()) {
            case ENCRYPTED: 
            case TEXT: {
                result = this.attributeRepository.create(dslId, ordering, attribute.getName(), attribute.getType(), null, null);
                break;
            }
            case DSL: 
            case CHANGE: {
                result = this.attributeRepository.create(dslId, ordering, attribute.getName(), attribute.getType(), attribute.getDataSetListReference().getId(), null);
                break;
            }
            case LIST: {
                ArrayList<String> valueNames = new ArrayList<String>();
                attribute.getListValues().forEach(listValue -> valueNames.add(listValue.getName()));
                result = this.attributeRepository.create(dslId, ordering, attribute.getName(), AttributeType.LIST, null, valueNames);
                break;
            }
            case FILE: {
                result = this.attributeRepository.create(dslId, ordering, attribute.getName(), AttributeType.FILE, null, null);
                break;
            }
            default: {
                log.error("Attribute " + attribute.getName() + " invalid type " + (Object)((Object)attribute.getType()) + " exception'");
                throw new AttributeTypeException(attribute.getName(), attribute.getType().toString());
            }
        }
        return result;
    }

    @Override
    public void updateOrdering(@Nonnull List<Pair<UUID, Integer>> attributesOrdering) {
        this.attributeRepository.updateOrdering(attributesOrdering);
    }

    @Override
    public void saveAttributeSortConfigurationForUser(@Nonnull UUID userId, boolean isSortEnabled) {
        UserSettingsEntity sortEnabledEntity = new UserSettingsEntity();
        sortEnabledEntity.setUserId(userId);
        if (isSortEnabled) {
            sortEnabledEntity.setAttributesSortType(AttributesSortType.SORT_BY_NAME);
        } else {
            sortEnabledEntity.setAttributesSortType(AttributesSortType.UNSORTED);
        }
        this.jpaAttributesSortEnabledRepository.save(sortEnabledEntity);
    }

    @Override
    public UserSettingsEntity getAttributeSortConfigurationForUser(@Nonnull UUID userId) {
        return this.jpaAttributesSortEnabledRepository.findByUserId(userId);
    }

    @Override
    public Map<String, List<UUID>> getParametersAndDataSetIdsForAttributeSorting(@NotNull UiManDataSetList tree, @Nonnull UUID dataSetListId, @Nonnull UUID targetAttrId, @Nonnull List<UUID> attrFilterIds) {
        HashMap<String, List<UUID>> mapAttributeValuesAndDataSetId = new HashMap<String, List<UUID>>();
        List<UiManParameter> attributeParameters = null;
        boolean isMultiplyAttr = false;
        List<UiManAttribute> attrs = this.getLastLevelAttributes(tree, attrFilterIds, targetAttrId);
        for (UiManAttribute attr : attrs) {
            if (!targetAttrId.equals(attr.getId())) continue;
            attributeParameters = attr.getParameters();
            isMultiplyAttr = AttributeType.CHANGE.equals((Object)attr.getSource().getType());
            break;
        }
        log.info("The targetAttribute Parameters have been parsed.");
        for (UiManParameter targetAttributeParameter : attributeParameters) {
            String paramValue = targetAttributeParameter.getValue().toString();
            UUID dataSetId = targetAttributeParameter.getDataSet();
            if (isMultiplyAttr) {
                paramValue = this.convertParamValueAsMultiply(paramValue, targetAttrId);
            }
            this.fillMapAttributeValuesAndDataSetIds(mapAttributeValuesAndDataSetId, paramValue, dataSetId);
        }
        log.info("Attribute values parsing done.");
        return mapAttributeValuesAndDataSetId;
    }

    private List<UiManAttribute> getLastLevelAttributes(@NotNull UiManDataSetList tree, List<UUID> attrFilterIds, UUID targetAttrId) {
        List<UiManAttribute> targetAttrs;
        List<UiManAttribute> allTreeAttrs = tree.getAttributes();
        if (targetAttrId.equals(attrFilterIds.get(0))) {
            log.info("First attrFilterId is equivalent: " + targetAttrId);
            targetAttrs = tree.getAttributes();
        } else {
            log.info("First attrFilterIds is not equivalent: " + targetAttrId);
            targetAttrs = this.getNestedObject(attrFilterIds, allTreeAttrs);
        }
        return targetAttrs;
    }

    private List<UiManAttribute> getNestedObject(List<UUID> attrPathIds, List<UiManAttribute> attrs) {
        if (attrPathIds.size() == 0) {
            return attrs;
        }
        UUID targetAttrId = attrPathIds.get(0);
        for (UiManAttribute attr : attrs) {
            if (!attr.getId().equals(targetAttrId)) continue;
            attrPathIds.remove(0);
            attrs = this.getNestedObject(attrPathIds, attr.getAttributes());
            break;
        }
        return attrs;
    }

    private String convertParamValueAsMultiply(String paramValue, UUID targetAttrId) {
        UiManDataSetList options = (UiManDataSetList)this.getOptions(targetAttrId);
        List<UiManDataSet> dsValues = options.getDataSets();
        paramValue = paramValue.replace(multiplyPrefix, "").trim();
        for (UiManDataSet dsValue : dsValues) {
            String dsId = dsValue.getId().toString();
            String dsName = dsValue.getName();
            if (!paramValue.contains(dsId)) continue;
            paramValue = paramValue.replace(dsId, dsName);
        }
        log.info("Dataset names for Multiply attribute have been changed.");
        return paramValue;
    }

    private void fillMapAttributeValuesAndDataSetIds(Map<String, List<UUID>> mapAttributeValuesAndDataSetId, String paramValue, UUID dataSetId) {
        if (Strings.isNonEmpty((String)paramValue)) {
            List<UUID> currentIds = mapAttributeValuesAndDataSetId.get(paramValue);
            if (Objects.nonNull(currentIds)) {
                currentIds.add(dataSetId);
                mapAttributeValuesAndDataSetId.put(paramValue, currentIds);
            } else {
                ArrayList<UUID> newList = new ArrayList<UUID>();
                newList.add(dataSetId);
                mapAttributeValuesAndDataSetId.put(paramValue, newList);
            }
        }
    }
}

