/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class ClearCacheServiceImpl
implements ClearCacheService {
    private static final Logger log = LoggerFactory.getLogger(ClearCacheServiceImpl.class);
    private final CacheManager cacheManager;

    public ClearCacheServiceImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void evictParameterCache(UUID parameterId) {
        log.info("Remove parameter - \"{}\" from Parameter cache", (Object)parameterId);
        this.cacheManager.getCache("ATP_DATASETS_PARAMETER_CACHE").evict((Object)parameterId);
    }

    @Override
    public void evictDatasetListContextCache(UUID datasetId) {
        log.info("Remove dataset - \"{}\" from DatasetListContext cache", (Object)datasetId);
        this.cacheManager.getCache("ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE").evict((Object)datasetId);
    }

    @Override
    public void evictDatasetListContextCache(Set<UUID> datasetIds) {
        log.info("Remove datasets - \"{}\" from DatasetListContext cache", datasetIds);
        Cache contextCache = this.cacheManager.getCache("ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE");
        if (Objects.nonNull(contextCache)) {
            datasetIds.forEach(arg_0 -> ((Cache)contextCache).evict(arg_0));
        }
    }
}

