/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;

public interface AttributeExportConverter {
    public void mapAttributeToRow(SXSSFRow var1, Set<UUID> var2, UiManAttribute var3);

    default public void mapAttributeToRow(SXSSFRow row, Set<UUID> datasetIds, UiManAttribute attribute, boolean isEncrypted) {
        HashMap mapParameterWithDataSet = new HashMap();
        attribute.getParameters().forEach(parameter -> mapParameterWithDataSet.put(parameter.getDataSet(), parameter));
        int nextCellIndex = 2;
        for (UUID datasetId : datasetIds) {
            SXSSFCell cell = row.createCell(nextCellIndex++);
            UiManParameter parameter2 = (UiManParameter)mapParameterWithDataSet.get(datasetId);
            if (!Objects.nonNull(parameter2)) continue;
            if (isEncrypted) {
                cell.setCellValue("********");
                continue;
            }
            cell.setCellValue(String.valueOf(parameter2.getValue()));
        }
    }
}

