/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.macros.schange;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.Change;
import org.qubership.atp.dataset.model.utils.ChangeType;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.macros.schange.MultiplicationEntry;

class ChangeParameter {
    private static final int UUID_LENGTH = 36;
    protected final Attribute targetAttribute;
    protected final Parameter targetParameter;
    protected final Change change;

    private ChangeParameter(@Nonnull Attribute targetAttribute, @Nonnull Parameter targetParameter, @Nonnull Change change) {
        this.targetAttribute = targetAttribute;
        this.targetParameter = targetParameter;
        this.change = change;
    }

    public static ChangeParameter create(@Nonnull Attribute targetAttribute, @Nonnull Parameter targetParameter, @Nonnull Change change) {
        switch (change.type) {
            case MULTIPLY: {
                return new Multiplication(targetAttribute, targetParameter, change);
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown type of structure change %s in %s", change, targetParameter));
    }

    public static Stream<List<MultiplicationEntry>> getCombinations(Stream<ChangeParameter> changes) {
        return Utils.combinations(ChangeParameter.getMultiplications(changes).collect(Collectors.toList()), Collectors.toList());
    }

    public static List<MultiplicationEntry> getCombination(Stream<ChangeParameter> changes, String metadata) {
        Iterator toChose = Splitter.fixedLength((int)36).splitToList((CharSequence)metadata).iterator();
        Iterator toChoseFrom = ChangeParameter.getMultiplications(changes).iterator();
        ArrayList<MultiplicationEntry> result = new ArrayList<MultiplicationEntry>(Math.round(metadata.length() / 36));
        while (toChoseFrom.hasNext()) {
            UUID target;
            List toSelectFrom = (List)toChoseFrom.next();
            if (!toChose.hasNext()) {
                throw new RuntimeException("Metadata is not fully provided. Resolved path: " + result + "; unresolved part - one of: " + toSelectFrom);
            }
            try {
                target = UUID.fromString((String)toChose.next());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Metadata does not contain an id. Resolved path: " + result + "; unresolved part - one of: " + toSelectFrom, e);
            }
            MultiplicationEntry entry = toSelectFrom.stream().filter(item -> target.equals(item.getValue())).findAny().orElseThrow(() -> new RuntimeException("Metadata contain an unknown id. Resolved path: " + result + "; unresolved part - one of: " + toSelectFrom + "; looking for: " + target));
            result.add(entry);
        }
        if (toChose.hasNext()) {
            ArrayList unresolvedPart = Lists.newArrayList(toChose);
            throw new RuntimeException("Metadata contain extra unresolved part. Resolved path: " + result + "; unresolved part: " + unresolvedPart);
        }
        return result;
    }

    public static Stream<List<MultiplicationEntry>> getMultiplications(Stream<ChangeParameter> changes) {
        return changes.filter(change -> ChangeType.MULTIPLY == change.change.type).map(ChangeParameter::asMultiplication).map(rec$ -> ((Multiplication)rec$).getEntries());
    }

    @Nonnull
    public static Stream<ChangeParameter> getChanges(@Nonnull Collection<Attribute> structureChanges, DataSet source) {
        if (structureChanges.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<ChangeParameter> result = null;
        for (Attribute changeAttr : structureChanges) {
            String text;
            Optional<Parameter> parameter = changeAttr.getParameters().stream().filter(param -> source.getId().equals(param.getDataSet().getId())).findAny();
            if (!parameter.isPresent() || Strings.isNullOrEmpty((String)(text = parameter.get().getText()))) continue;
            Change change = Change.fromText(text);
            if (result == null) {
                result = new ArrayList<ChangeParameter>(5);
            }
            result.add(ChangeParameter.create(changeAttr, parameter.get(), change));
        }
        return result == null ? Stream.empty() : result.stream();
    }

    public Multiplication asMultiplication() {
        Preconditions.checkArgument((ChangeType.MULTIPLY == this.change.type ? 1 : 0) != 0, (String)"%s is not a multiplication", (Object)this);
        return (Multiplication)this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("targetAttribute", (Object)this.targetAttribute).add("targetParameter", (Object)this.targetParameter).add("change", (Object)this.change).toString();
    }

    public static class Multiplication
    extends ChangeParameter {
        protected final UUID dataSetListId;
        protected final List<UUID> dataSetIds;

        private Multiplication(@Nonnull Attribute targetAttribute, @Nonnull Parameter targetParameter, @Nonnull Change change) {
            super(targetAttribute, targetParameter, change);
            this.dataSetListId = targetAttribute.getDataSetListReference().getId();
            this.dataSetIds = change.arguments;
        }

        private List<MultiplicationEntry> getEntries() {
            return this.dataSetIds.stream().map(id -> new MultiplicationEntry(this, (UUID)id)).collect(Collectors.toList());
        }
    }
}

