/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.model.copy.DataSetListCopyData;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSetListAsyncService {
    private static final Logger log = LoggerFactory.getLogger(DataSetListAsyncService.class);
    @Autowired
    protected ModelsProvider modelsProvider;
    private final DataSetListSnapshotService commitEntityService;

    public DataSetListAsyncService(DataSetListSnapshotService commitEntityService) {
        this.commitEntityService = commitEntityService;
    }

    @Async(value="asyncCopyTaskExecutor")
    @Transactional
    public Future<DataSetListCopyData> duplicate(UUID dataSetListId, @Nullable String postfix, String prevNamePattern, @Nullable UUID sagaSessionId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        log.info("Start copy Dataset List with id {} and name {}.", (Object)dataSetListId, (Object)dataSetList.getName());
        DataSetListCopyData duplicateData = dataSetList.duplicate(postfix, prevNamePattern, sagaSessionId);
        this.commitEntityService.findAndCommitIfExists(duplicateData.getCopyId());
        DataSetList dataSetListCopy = duplicateData.getDataSetListCopy();
        log.info("Finish copy Dataset List with id {} and name {}. New id {} and new name {}", new Object[]{dataSetListId, dataSetList.getName(), dataSetListCopy.getId(), dataSetListCopy.getName()});
        return new AsyncResult((Object)duplicateData);
    }

    @Async(value="asyncCopyTaskExecutor")
    @Transactional
    public Future<?> updateOverlaps(DataSetList dataSetList, Map<UUID, DataSetListCopyData> copiesData) {
        log.info("Update overlaps for Dataset List {}", (Object)dataSetList.getId());
        dataSetList.updateOverlaps(copiesData);
        return new AsyncResult(null);
    }
}

