/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.attribute.AttributeParentDslCopyException;
import org.qubership.atp.dataset.exception.attribute.AttributeParentDslNotExistException;
import org.qubership.atp.dataset.exception.dataset.DataSetExistsException;
import org.qubership.atp.dataset.exception.dataset.DataSetLockedException;
import org.qubership.atp.dataset.exception.dataset.DataSetNotFoundException;
import org.qubership.atp.dataset.exception.dataset.DataSetPositionException;
import org.qubership.atp.dataset.exception.dataset.DataSetSerializeItfContextException;
import org.qubership.atp.dataset.model.enums.DetailedComparisonStatus;
import org.qubership.atp.dataset.service.direct.CompareService;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.ParameterValue;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.CacheCleanupService;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetTree;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.itf.ItfContextSerializer;
import org.qubership.atp.dataset.service.rest.dto.manager.AbstractEntityResponse;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaDataSetServiceImpl
implements JpaDataSetService {
    private static final Logger log = LoggerFactory.getLogger(JpaDataSetServiceImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(JpaDataSetServiceImpl.class);
    @Autowired
    protected JpaDataSetListService dataSetListService;
    @Autowired
    protected JpaParameterService jpaParameterService;
    @Autowired
    protected DataSetParameterProvider dataSetParameterProvider;
    @Autowired
    protected MacroContextService macroContextService;
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected CacheCleanupService cacheCleanupService;
    @Autowired
    @Lazy
    protected JpaDataSetService self;
    @Autowired
    protected MacrosFeignClient macrosFeignClient;
    @Autowired
    protected MacrosCalculator macrosCalculator;
    @Autowired
    protected DataSetListSnapshotService dataSetListSnapshotService;
    @Autowired
    protected DateAuditorService dateAuditorService;
    @Autowired
    protected CompareService compareService;
    @Autowired
    protected JpaAttributeService jpaAttributeService;
    @Autowired
    protected GridFsService gridFsService;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Override
    @Transactional(readOnly=true)
    public DataSetTree getDataSetTreeInAtpFormat(UUID dataSetId, boolean evaluate, String atpContextString, ContextType contextType) {
        DataSetListContext dataSetListContext = this.self.getDatasetListContext(dataSetId);
        MacroContext macroContext = new MacroContext();
        macroContext.setMacroContextService(this.macroContextService);
        macroContext.setMacrosCalculator(this.macrosCalculator);
        List macrosDtoList = (List)this.macrosFeignClient.findAllByProject(dataSetListContext.getVisibilityAreaId()).getBody();
        List macros = new MacrosDtoConvertService().convertList(macrosDtoList, Macros.class);
        macroContext.setMacros(macros);
        macroContext.setDataSetListContext(dataSetListContext);
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        macroContext.fillAtpDataSetContext(dataSet);
        if (StringUtils.isNotEmpty((String)atpContextString)) {
            macroContext.addAtpDataSetContext(atpContextString);
        }
        return this.getTree(dataSetId, evaluate, macroContext, contextType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<JSONObject> getDataSetTreeInAtpFormat(UUID dataSetId, boolean evaluate, String atpContextString, ContextType contextType, Integer numberOfCopies) {
        log.info("getDataSetTreeInAtpFormat start. numberOfCopies={}", (Object)numberOfCopies);
        DataSetListContext dataSetListContext = this.self.getDatasetListContext(dataSetId);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        int cnt = numberOfCopies;
        List macrosDtoList = (List)this.macrosFeignClient.findNonTechnicalMacrosByProject(dataSetListContext.getVisibilityAreaId()).getBody();
        if (null != macrosDtoList) {
            log.info("size for macrosDtoList received is: {}", (Object)macrosDtoList.size());
        }
        List macros = new MacrosDtoConvertService().convertList(macrosDtoList, Macros.class);
        while (cnt > 0) {
            MacroContext macroContext = new MacroContext();
            macroContext.setMacroContextService(this.macroContextService);
            macroContext.setDataSetListContext(dataSetListContext);
            macroContext.setMacrosCalculator(this.macrosCalculator);
            macroContext.setMacros(macros);
            if (StringUtils.isNotEmpty((String)atpContextString)) {
                macroContext.addAtpDataSetContext(atpContextString);
            }
            DataSetTree tree = this.getTree(dataSetId, evaluate, macroContext, contextType);
            try {
                result.add((JSONObject)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)tree), JSONObject.class));
            }
            catch (Exception e) {
                log.error("Cannot write/read tree", (Throwable)e);
                result.add(new JSONObject());
            }
            this.cleanCache();
            --cnt;
        }
        log.info("getDataSetTreeInAtpFormat end. result.size = {}", (Object)result.size());
        return result;
    }

    private void cleanCache() {
        this.cacheCleanupService.cleanMacroContextCache();
    }

    @Override
    @Cacheable(value={"ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE"}, key="#dataSetId")
    public DataSetListContext getDatasetListContext(UUID dataSetId) {
        UUID dslId = this.modelsProvider.getDatasetListIdByDatasetId(dataSetId);
        return this.dataSetListService.getDataSetListContext(dslId, Collections.singletonList(dataSetId));
    }

    @Override
    @Transactional
    public void remove(UUID dataSetId) {
        DataSetList object = this.modelsProvider.getDataSetListById(dataSetId);
        if (object != null) {
            object.remove();
        }
    }

    @Override
    public String getDataSetTreeInItfFormat(UUID dataSetId) {
        DataSetTree dataSetTreeInAtpFormat = this.self.getDataSetTreeInAtpFormat(dataSetId, true, null, ContextType.OBJECT);
        return this.serializeToItfJson(dataSetTreeInAtpFormat);
    }

    @Override
    @Transactional
    public DataSet create(String name, UUID dataSetListId) {
        for (String dataSetName : this.modelsProvider.getDsNamesForDsl(dataSetListId)) {
            if (!dataSetName.equalsIgnoreCase(name)) continue;
            log.error("Dataset with name '" + name + "' already exists");
            throw new DataSetExistsException(name);
        }
        return this.createDataSet(name, dataSetListId, true);
    }

    @Override
    @Transactional
    public DataSet createDsSelectJavers(String name, UUID dataSetListId, boolean isJavers) {
        return this.createDataSet(name, dataSetListId, isJavers);
    }

    private DataSet createDataSet(String name, UUID dataSetListId, boolean isJavers) {
        DataSetList dataSetList = this.dataSetListService.getById(dataSetListId);
        DataSet dataSet = dataSetList.createDataSet(name);
        if (isJavers) {
            log.debug("Javers activated");
            this.dataSetListSnapshotService.commitEntity(dataSetListId);
        }
        return dataSet;
    }

    @Override
    @Transactional
    public DataSet replicate(UUID id, String name, UUID dataSetListId, Long ordering, UUID sourceId, Boolean isLocked) throws DataSetServiceException {
        return this.modelsProvider.replicateDataSet(id, name, dataSetListId, ordering, sourceId, isLocked);
    }

    @Override
    @Transactional
    public Parameter setParameterValue(ParameterValue value, UUID dataSetId, UUID attributeId) {
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        Parameter parameter = dataSet.getParameterByAttributeId(attributeId);
        if (parameter == null) {
            parameter = dataSet.createParameter(attributeId);
        }
        Attribute attribute = parameter.getAttribute();
        this.resolveAndSetParameterValue(parameter, attribute.getAttributeType(), value);
        return parameter;
    }

    @Override
    @Transactional
    public void lock(UUID dataSetListId, List<UUID> datasetIds, boolean isLock) {
        datasetIds.forEach(dsId -> {
            DataSet dataSet = this.modelsProvider.getDataSetById((UUID)dsId);
            dataSet.setLocked(isLock);
            dataSet.save();
        });
        this.dateAuditorService.updateModifiedFields(dataSetListId);
        this.dataSetListSnapshotService.commitEntity(dataSetListId);
    }

    @Override
    @Transactional
    public void setOverlapValue(ParameterValue value, UUID dataSetId, UUID foreignAttributeId, List<UUID> attributePath) {
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        Parameter overlapParameter = dataSet.createOverlap(foreignAttributeId, attributePath);
        Attribute foreignAttribute = this.modelsProvider.getAttributeById(foreignAttributeId);
        this.resolveAndSetParameterValue(overlapParameter, foreignAttribute.getAttributeType(), value);
    }

    @Override
    @Transactional
    public DataSet getById(UUID id) {
        return this.modelsProvider.getDataSetById(id);
    }

    @Override
    public List<DataSet> getByIds(Collection<UUID> ids) {
        return this.modelsProvider.getByIds(ids);
    }

    @Override
    @Transactional
    public void save(DataSet dataSet) {
        dataSet.save();
    }

    @Override
    @Transactional
    public void setPosition(UUID dataSetId, Integer position) {
        if (position == null || position < 0) {
            throw new DataSetPositionException();
        }
        DataSet dataSetToMove = this.modelsProvider.getDataSetById(dataSetId);
        if (dataSetToMove == null) {
            log.error("Dataset '" + dataSetId + "' not found");
            throw new DataSetNotFoundException();
        }
        List<DataSet> dataSets = dataSetToMove.getDataSetList().getDataSets();
        if (position > dataSets.size() - 1) {
            throw new DataSetPositionException();
        }
        dataSets.remove(dataSetToMove);
        dataSets.add(position, dataSetToMove);
        long orderingCounter = 0L;
        for (DataSet dataSet : dataSets) {
            dataSet.setOrdering(orderingCounter);
            ++orderingCounter;
        }
    }

    @Override
    public List<DataSet> getByNameAndDataSetListId(String name, UUID dataSetList) {
        return this.modelsProvider.getDataSetByNameAndDataSetListId(name, dataSetList);
    }

    @Override
    public List<DataSet> getByDataSetListId(UUID dataSetList) {
        return this.modelsProvider.getDataSetByDataSetListId(dataSetList);
    }

    @Override
    public List<DataSet> getLockedDataSets(UUID dataSetList) {
        return this.modelsProvider.getLockedDatasets(dataSetList);
    }

    @Override
    public List<DataSet> getByDataSetListIdIn(Collection<UUID> dataSetListIds) {
        return this.modelsProvider.getByDataSetListIdIn(dataSetListIds);
    }

    @Override
    public List<DataSet> getBySourceAndDataSetListId(UUID sourceId, UUID dataSetList) {
        return this.modelsProvider.getDataSetBySourceAndDataSetListId(sourceId, dataSetList);
    }

    private void resolveAndSetParameterValue(Parameter parameter, AttributeTypeName attributeType, ParameterValue value) {
        switch (attributeType) {
            case TEXT: 
            case ENCRYPTED: 
            case CHANGE: {
                parameter.setStringValue(value.getString());
                break;
            }
            case DSL: {
                parameter.setDataSetReferenceId(value.getUuid());
                break;
            }
            case LIST: {
                parameter.setListValueId(value.getUuid());
                break;
            }
            case FILE: {
                parameter.setFileValueId(value.getUuid());
                break;
            }
        }
    }

    private DataSetTree getTree(UUID dataSetId, boolean evaluate, MacroContext macroContext, ContextType contextType) {
        DataSetListContext dataSetListContext = macroContext.getDataSetListContext();
        List<DataSetContext> rootDataSets = dataSetListContext.getDataSets();
        for (DataSetContext rootDataSet : rootDataSets) {
            if (!rootDataSet.getId().equals(dataSetId)) continue;
            return new DataSetTree(rootDataSet, rootDataSet.getColumnNumber(), evaluate, macroContext, dataSetListContext, this.dataSetParameterProvider, contextType);
        }
        log.error("Data Set not found. Id='" + dataSetId + "'");
        throw new DataSetNotFoundException();
    }

    private String serializeToItfJson(DataSetTree tree) {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(DataSetTree.class, (JsonSerializer)new ItfContextSerializer());
        mapper.registerModule((Module)module);
        try {
            return mapper.writer().writeValueAsString((Object)tree);
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to serialize itf context", (Throwable)e);
            throw new DataSetSerializeItfContextException();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AbstractEntityResponse> getDatasetsIdNamesPageByNameAndVaId(String name, UUID visibilityAreaId, Pageable pageable) {
        return this.modelsProvider.getDatasetsIdNamesPageByNameAndVaId(name, visibilityAreaId, pageable);
    }

    public UUID getDataSetsListIdByDataSetId(UUID dsId) {
        return this.modelsProvider.getDataSetsListIdByDataSetId(dsId);
    }

    @Override
    @Transactional
    public void copyDsAttributeValueBulk(UUID sourceDsId, UUID targetDsId) {
        log.debug("copyDsAttributeValueBulk (sourceDsId: {}, targetDsId: {})", (Object)sourceDsId, (Object)targetDsId);
        List<Attribute> attributes = this.modelsProvider.getAttributesByDataSetId(sourceDsId);
        attributes.addAll(this.modelsProvider.getAttributesByDataSetId(targetDsId));
        Map groupedAttributes = attributes.stream().collect(Collectors.groupingBy(Attribute::getName, HashMap::new, Collectors.toList()));
        UUID targetDslId = this.getById(targetDsId).getDataSetList().getId();
        for (Map.Entry entry : groupedAttributes.entrySet()) {
            List values = (List)entry.getValue();
            if (values.size() == 2) {
                UUID rightAttrId;
                UUID leftAttrId = ((Attribute)values.get(0)).getId();
                if (DetailedComparisonStatus.EQUAL.equals((Object)this.compareService.compareAttributeValues(sourceDsId, targetDsId, leftAttrId, rightAttrId = ((Attribute)values.get(1)).getId()))) continue;
                this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, leftAttrId, rightAttrId);
                continue;
            }
            Attribute attribute = (Attribute)values.get(0);
            if (targetDslId.equals(attribute.getDataSetList().getId())) {
                this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, null, attribute.getId());
                continue;
            }
            this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, attribute.getId(), null);
        }
        List<AttributeKey> attributeKeys = this.modelsProvider.getAttributesKeyByDataSetId(sourceDsId);
        attributeKeys.addAll(this.modelsProvider.getAttributesKeyByDataSetId(targetDsId));
        Map groupedAttributeKeys = attributeKeys.stream().collect(Collectors.groupingBy(attributeKey -> attributeKey.getName() + "." + attributeKey.getPathNames(), HashMap::new, Collectors.toList()));
        for (Map.Entry entry : groupedAttributeKeys.entrySet()) {
            List values = (List)entry.getValue();
            if (values.size() == 2) {
                UUID rightAttrId;
                UUID leftAttrId = ((AttributeKey)values.get(0)).getId();
                if (DetailedComparisonStatus.EQUAL.equals((Object)this.compareService.compareAttributeValues(sourceDsId, targetDsId, leftAttrId, rightAttrId = ((AttributeKey)values.get(1)).getId()))) continue;
                this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, leftAttrId, rightAttrId);
                continue;
            }
            AttributeKey attributeKey2 = (AttributeKey)values.get(0);
            if (targetDslId.equals(attributeKey2.getDataSetList().getId())) {
                this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, null, attributeKey2.getId());
                continue;
            }
            this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, attributeKey2.getId(), null);
        }
        this.dataSetListSnapshotService.commitEntity(targetDslId);
    }

    private UUID copyDsAttributeValueWithoutCommitting(UUID sourceDsId, UUID targetDsId, @Nullable UUID sourceAttrId, @Nullable UUID targetAttrId) {
        log.debug("copyDsAttributeValue (sourceDsId: {}, targetDsId: {}, sourceAttrId: {}, targetAttrId: {})", new Object[]{sourceDsId, targetDsId, sourceAttrId, targetAttrId});
        DataSet targetDataset = this.modelsProvider.getDataSetById(targetDsId);
        if (Objects.isNull(targetDataset)) {
            log.error("Data Set not found. Id='{}'", (Object)targetDsId);
            throw new DataSetNotFoundException();
        }
        if (targetDataset.isLocked()) {
            log.error("Dataset is locked. (Id: {})", (Object)targetDsId);
            throw new DataSetLockedException(targetDataset.getName());
        }
        Parameter sourceParameter = this.modelsProvider.getParameterByAttributeIdAndDataSetId(sourceAttrId, sourceDsId);
        Parameter targetParameter = this.modelsProvider.getParameterByAttributeIdAndDataSetId(targetAttrId, targetDsId);
        if (Objects.nonNull(sourceParameter) && sourceParameter.isOverlap() || Objects.nonNull(targetParameter) && targetParameter.isOverlap()) {
            targetAttrId = this.copyOverlapParameter(targetDataset, sourceParameter, targetParameter);
        } else if (this.compareService.isAttributesComparable(sourceAttrId, targetAttrId)) {
            log.debug("Attributes are comparable (sourceAttrId: {}, targetAttrId: {})", (Object)sourceAttrId, (Object)targetAttrId);
            this.copyAttributeIfComparable(sourceParameter, targetParameter, targetDsId, targetAttrId);
        } else {
            log.debug("Attributes are not comparable (sourceAttrId: {}, targetAttrId: {})", (Object)sourceAttrId, (Object)targetAttrId);
            targetAttrId = this.copyAttributeIfNotComparable(sourceAttrId, sourceParameter, targetDsId, targetAttrId);
        }
        return targetAttrId;
    }

    @Override
    @Transactional
    public UUID copyDsAttributeValue(UUID sourceDsId, UUID targetDsId, @Nullable UUID sourceAttrId, @Nullable UUID targetAttrId) {
        if (!DetailedComparisonStatus.EQUAL.equals((Object)this.compareService.compareAttributeValues(sourceDsId, targetDsId, sourceAttrId, targetAttrId))) {
            targetAttrId = this.copyDsAttributeValueWithoutCommitting(sourceDsId, targetDsId, sourceAttrId, targetAttrId);
            this.dataSetListSnapshotService.commitEntity(this.jpaAttributeService.getById(targetAttrId).getDataSetList().getId());
        }
        return targetAttrId;
    }

    private void copyAttributeIfComparable(@Nullable Parameter sourceParameter, @Nullable Parameter targetParameter, UUID targetDsId, UUID targetAttrId) {
        if (Objects.isNull(sourceParameter)) {
            if (Objects.nonNull(targetParameter)) {
                log.debug("Remove parameter from target DS. Parameter_id: {}", (Object)targetParameter.getId());
                this.jpaParameterService.removeWithoutCommitting(targetParameter.getId());
            }
        } else {
            Parameter newParameter;
            AttributeTypeName sourceAttributeType = sourceParameter.getAttribute().getAttributeType();
            UUID newListValueReference = null;
            if (AttributeTypeName.LIST.equals((Object)sourceAttributeType)) {
                newListValueReference = this.jpaAttributeService.mergeListValuesAndGetListValueReference(sourceParameter.getAttributeId(), targetAttrId, sourceParameter.getListValue());
            }
            if (Objects.isNull(targetParameter)) {
                log.debug("Target parameter not exist - create new one. (targetAttrId: {}, targetDsId: {}, sourceParameterId: {})", new Object[]{targetAttrId, targetDsId, sourceParameter.getId()});
                newParameter = this.jpaParameterService.createParameterWithoutCommitting(targetDsId, targetAttrId, sourceParameter.getStringValue(), sourceParameter.getDataSetReferenceId(), newListValueReference);
            } else {
                log.debug("Target parameter exist - update parameter value. (sourceParameterId: {}, targetParameterId: {})", (Object)sourceParameter.getId(), (Object)targetParameter.getId());
                newParameter = this.jpaParameterService.updateParameterWithoutCommitting(targetParameter.getId(), sourceParameter.getStringValue(), sourceParameter.getDataSetReferenceId(), newListValueReference);
            }
            if (AttributeTypeName.FILE.equals((Object)sourceAttributeType)) {
                this.gridFsService.copyIfExist(sourceParameter.getId(), newParameter.getId(), false);
            }
        }
    }

    private UUID copyAttributeIfNotComparable(@Nullable UUID sourceAttrId, @Nullable Parameter sourceParameter, UUID targetDsId, @Nullable UUID targetAttrId) {
        if (Objects.nonNull(targetAttrId) && Objects.nonNull(sourceAttrId)) {
            log.debug("Remove attribute from target DS. (attribute_id: {})", (Object)targetAttrId);
            this.jpaAttributeService.remove(targetAttrId);
        }
        if (Objects.isNull(sourceAttrId)) {
            return null;
        }
        Attribute sourceAttribute = Objects.isNull(sourceParameter) ? this.modelsProvider.getAttributeById(sourceAttrId) : sourceParameter.getAttribute();
        AttributeTypeName sourceAttributeType = sourceAttribute.getAttributeType();
        log.debug("Create new target attribute with type {}", (Object)sourceAttributeType);
        UUID targetDataSetListId = this.getById(targetDsId).getDataSetList().getId();
        Attribute newAttribute = this.jpaAttributeService.createWithoutCommitting(sourceAttribute.getName(), sourceAttributeType, targetDataSetListId);
        targetAttrId = newAttribute.getId();
        if (AttributeTypeName.DSL.equals((Object)sourceAttributeType)) {
            newAttribute.setTypeDataSetListId(sourceAttribute.getTypeDataSetListId());
        }
        if (Objects.nonNull(sourceParameter)) {
            log.debug("Create new parameter in new target attribute (attribute_id: {})", (Object)targetAttrId);
            UUID newListValueReference = null;
            if (AttributeTypeName.LIST.equals((Object)sourceAttributeType)) {
                newListValueReference = this.jpaAttributeService.mergeListValuesAndGetListValueReference(sourceAttrId, targetAttrId, sourceParameter.getListValue());
            }
            Parameter newParameter = this.jpaParameterService.createParameterWithoutCommitting(targetDsId, targetAttrId, sourceParameter.getStringValue(), sourceParameter.getDataSetReferenceId(), newListValueReference);
            if (AttributeTypeName.FILE.equals((Object)sourceAttributeType)) {
                this.gridFsService.copyIfExist(sourceParameter.getId(), newParameter.getId(), false);
            }
        }
        return targetAttrId;
    }

    private UUID copyOverlapParameter(DataSet targetDataset, @Nullable Parameter sourceParameter, @Nullable Parameter targetParameter) {
        UUID targetHeadLinkAttrId;
        if (Objects.isNull(sourceParameter) && Objects.nonNull(targetParameter)) {
            UUID attrId = targetParameter.getAttributeKey().getPath().get(0);
            targetParameter.remove();
            return attrId;
        }
        if (Objects.isNull(targetParameter)) {
            UUID headLinkAttrId = sourceParameter.getAttributeKey().getPath().get(0);
            Attribute sourceHeadLinkAttr = this.jpaAttributeService.getById(headLinkAttrId);
            Optional<Attribute> targetHeadLinkAttr = targetDataset.getDataSetList().getAttributes().stream().filter(attr -> attr.getName().equals(sourceHeadLinkAttr.getName()) && attr.getAttributeType().equals((Object)sourceHeadLinkAttr.getAttributeType())).findFirst();
            if (!targetHeadLinkAttr.isPresent()) {
                throw new AttributeParentDslNotExistException();
            }
            boolean isDslDifferent = this.modelsProvider.isDslDifferentAttributes(headLinkAttrId, targetHeadLinkAttr.get().getId());
            if (isDslDifferent) {
                throw new AttributeParentDslCopyException();
            }
            UUID targetAttrId = targetHeadLinkAttr.get().getId();
            List<UUID> path = sourceParameter.getAttributeKey().getPath();
            path.remove(0);
            path.add(0, targetAttrId);
            this.jpaParameterService.createParameterOverlapWithoutCommitting(sourceParameter.getAttributeKey().getAttributeId(), path, targetDataset.getId(), sourceParameter.getStringValue(), sourceParameter.getDataSetReferenceId(), sourceParameter.getListValueId());
            return targetAttrId;
        }
        UUID sourceHeadLinkAttrId = sourceParameter.getAttributeKey().getPath().get(0);
        boolean isDslDifferent = this.modelsProvider.isDslDifferentAttributes(sourceHeadLinkAttrId, targetHeadLinkAttrId = targetParameter.getAttributeKey().getPath().get(0));
        if (isDslDifferent) {
            throw new AttributeParentDslCopyException();
        }
        this.jpaParameterService.updateOverlapParameterWithoutCommitting(targetParameter, sourceParameter.getStringValue(), sourceParameter.getDataSetReferenceId(), sourceParameter.getListValueId());
        if (AttributeTypeName.FILE.equals((Object)sourceParameter.getAttributeKey().getAttributeType())) {
            this.gridFsService.copyIfExist(sourceParameter.getId(), targetParameter.getId(), false);
        }
        return targetHeadLinkAttrId;
    }
}

