/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.UUID;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricsService {
    private static final Logger log = LoggerFactory.getLogger(MetricsService.class);
    public static final String ATP_MAX_SIZE_DOWNLOAD_FILE_PER_PROJECT_TOTAL = "atp.data.sets.max.size.download.file.per.project.total";
    public static final String ATP_MAX_SIZE_UPLOAD_FILE_PER_PROJECT_TOTAL = "atp.data.sets.max.size.upload.file.per.project.total";
    private static final String PROJECT_ID = "projectId";
    private final Counter.Builder uploadFileCounter = Counter.builder((String)"atp.data.sets.max.size.upload.file.per.project.total").description("Counter for all requests");
    private final Counter.Builder downloadFileCounter = Counter.builder((String)"atp.data.sets.max.size.download.file.per.project.total").description("Counter for run collections");
    private final MeterRegistry meterRegistry;
    private HashMap<String, HashMap<String, Long>> storage = new HashMap();

    @Autowired
    public MetricsService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    private void incrementByBuilderCounterAndTags(Counter.Builder counter, String metricName, long fileSize, String projectId) {
        Long size = this.calculateSize(fileSize);
        if (!this.storage.containsKey(metricName)) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put(projectId, size);
            this.storage.put(metricName, map);
            this.registerMetricSize(counter, size, projectId);
        } else {
            HashMap<String, Long> map = this.storage.get(metricName);
            if (!map.containsKey(projectId)) {
                HashMap<String, Long> projectMapWithSize = new HashMap<String, Long>();
                projectMapWithSize.put(projectId, size);
                this.registerMetricSize(counter, size, projectId);
            } else {
                Long existSize = map.get(projectId);
                if (existSize <= size) {
                    Long differenceSize = size - existSize;
                    existSize = existSize + differenceSize;
                    this.storage.get(metricName).replace(projectId, existSize);
                    this.registerMetricSize(counter, differenceSize, projectId);
                }
            }
        }
    }

    private void registerMetricSize(Counter.Builder counter, long fileSize, String projectId) {
        counter.tag(PROJECT_ID, projectId).register(this.meterRegistry).increment((double)fileSize);
    }

    private void incrementByTypeTag(long size, @NonNull UUID projectId, @NonNull String counterType) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (counterType == null) {
            throw new NullPointerException("counterType is marked non-null but is null");
        }
        switch (counterType) {
            case "atp.data.sets.max.size.upload.file.per.project.total": {
                this.incrementByBuilderCounterAndTags(this.uploadFileCounter, ATP_MAX_SIZE_UPLOAD_FILE_PER_PROJECT_TOTAL, size, projectId.toString());
                break;
            }
            case "atp.data.sets.max.size.download.file.per.project.total": {
                this.incrementByBuilderCounterAndTags(this.downloadFileCounter, ATP_MAX_SIZE_DOWNLOAD_FILE_PER_PROJECT_TOTAL, size, projectId.toString());
                break;
            }
        }
    }

    public void registerMetricFileSize(long size, UUID projectId, String metricName) {
        this.incrementByTypeTag(size, projectId, metricName);
    }

    private Long calculateSize(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

