/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl.macro;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResult;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResultContainer;
import org.qubership.atp.dataset.service.jpa.model.MacroContextService;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.macros.core.calculator.MacrosCalculator;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroContext {
    private static final Logger log = LoggerFactory.getLogger(MacroContext.class);
    private Map<String, Object> atpContext = new HashMap<String, Object>();
    private DataSetListContext dataSetListContext;
    private MacroContextService macroContextService;
    private List<Macros> macros = new ArrayList<Macros>();
    private MacrosCalculator macrosCalculator;

    public CachedDslMacroResult getCachedDslTextParameter(PathStep dataSetList, PathStep dataSetId, List<PathStep> attributeGroups, PathStep attributeId) throws DataSetServiceException {
        CachedDslMacroResultContainer dslMacroCache = this.macroContextService.getDslMacroCache();
        return dslMacroCache.getCachedValue(dataSetList, dataSetId, attributeGroups, attributeId);
    }

    public void storeCachedDslTextParameter(PathStep dataSetList, PathStep dataSetId, List<PathStep> attributeGroups, PathStep attributeId, String value) throws DataSetServiceException {
        CachedDslMacroResultContainer dslMacroCache = this.macroContextService.getDslMacroCache();
        dslMacroCache.storeValue(dataSetList, dataSetId, attributeGroups, attributeId, value);
    }

    public String getDslTextParameter(UUID visibilityAreaId, PathStep dataSetList, PathStep dataSetId, List<PathStep> attributeGroups, PathStep attributeId) throws DataSetServiceException {
        return this.macroContextService.getTextParameterByExternalListDataSetAndPath(visibilityAreaId, dataSetList, dataSetId, attributeGroups, attributeId);
    }

    public String getTextParameter(PathStep dataSet, List<PathStep> attributeGroups, PathStep attribute) {
        try {
            return this.macroContextService.getTextParameterByListDataSetAndPath(this.dataSetListContext.getVisibilityAreaId(), new PathStep(this.dataSetListContext.getDataSetListId()), dataSet, attributeGroups, attribute);
        }
        catch (DataSetServiceException e) {
            log.error("Referenced variable for {} not found", (Object)attribute, (Object)e);
            return "[" + e.getMessage() + "]";
        }
    }

    public String getTextParameterFromCachedContextByNamesPath(ParameterPositionContext parameterPositionContext, List<PathStep> attributeGroupsPath, PathStep attribute) {
        UUID topLevelDataSetListId = this.getDataSetListContext().getDataSetListId();
        UUID visibilityAreaId = this.getDataSetListContext().getVisibilityAreaId();
        try {
            return this.macroContextService.getTextParameterFromCachedContextByNamesPath(visibilityAreaId, new PathStep(topLevelDataSetListId), parameterPositionContext.getDataSetInColumnId(), parameterPositionContext.getDataSetColumn(), parameterPositionContext.getPath(), attributeGroupsPath, attribute);
        }
        catch (DataSetServiceException e) {
            log.error("Referenced variable for {} not found", (Object)attribute, (Object)e);
            return "[" + e.getMessage() + "]";
        }
    }

    public String getValueFromAtpContext(String variable) {
        Object value = this.atpContext.getOrDefault(variable, null);
        return Objects.nonNull(value) ? value.toString() : null;
    }

    public void addAtpDataSetContext(String jsonString) {
        this.atpContext.putAll(this.deserializeContext(jsonString));
    }

    public void fillAtpDataSetContext(DataSet dataSet) {
        List<Parameter> parameters = dataSet.getParameters();
        parameters.forEach(parameter -> {
            Attribute attribute = parameter.getAttribute();
            if (attribute != null) {
                this.atpContext.put(attribute.getName(), parameter.getParameterValueByType());
            }
        });
    }

    public void setDataSetListContext(DataSetListContext dataSetListContext) {
        this.dataSetListContext = dataSetListContext;
    }

    private Map<String, String> deserializeContext(String context) {
        Type itemsMapType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)new Gson().fromJson(context, itemsMapType);
    }

    public String getDataSetListName(UUID dataSetListId) throws DataSetServiceException {
        return this.macroContextService.getDataSetListName(dataSetListId);
    }

    public String getDataSetName(UUID dataSetId) throws DataSetServiceException {
        return this.macroContextService.getDataSetName(dataSetId);
    }

    public String getAttributeName(UUID attributeId) throws DataSetServiceException {
        return this.macroContextService.getAttributeName(attributeId);
    }

    public UUID getDataSetIdByNameAndDataSetList(String name, UUID dataSetListId) {
        return this.macroContextService.getDataSetUuid(name, dataSetListId);
    }

    public DataSetList getDataSetList(UUID visibilityAreaId, PathStep dataSetList) throws DataSetServiceException {
        return this.macroContextService.getDataSetList(visibilityAreaId, dataSetList);
    }

    public Map<String, Object> getAtpContext() {
        return this.atpContext;
    }

    public DataSetListContext getDataSetListContext() {
        return this.dataSetListContext;
    }

    public MacroContextService getMacroContextService() {
        return this.macroContextService;
    }

    public void setMacroContextService(MacroContextService macroContextService) {
        this.macroContextService = macroContextService;
    }

    public List<Macros> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macros> macros) {
        this.macros = macros;
    }

    public MacrosCalculator getMacrosCalculator() {
        return this.macrosCalculator;
    }

    public void setMacrosCalculator(MacrosCalculator macrosCalculator) {
        this.macrosCalculator = macrosCalculator;
    }
}

