/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AtpMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ContextMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.DateMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.RefDslMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.RefMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.RefThisMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.UnknownMacro;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacro
extends AbstractTextParameter {
    private static final Logger log = LoggerFactory.getLogger(AbstractMacro.class);
    public static final String DATASET_MACRO_MARKER = "#";
    private static final Logger LOG = LoggerFactory.getLogger(TextParameterParser.class);
    private MacroContext macroContext;
    private ParameterPositionContext parameterPositionContext;
    private boolean evaluate = false;
    private String macroNameWithMarker;

    public AbstractMacro(String macroNameWithMarker, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        this.macroContext = macroContext;
        this.parameterPositionContext = parameterPositionContext;
        this.macroNameWithMarker = macroNameWithMarker;
    }

    public static AbstractMacro getMacroByName(String macroNameWithMarker, MacroContext macroContext, boolean evaluate, ParameterPositionContext parameterPositionContext) {
        String macroMarker;
        String nameWithoutMacroMarker = Objects.nonNull(macroNameWithMarker) ? macroNameWithMarker.substring(1) : null;
        String string = macroMarker = Objects.nonNull(macroNameWithMarker) ? macroNameWithMarker.substring(0, 1) : null;
        AbstractMacro macro = "CONTEXT".equalsIgnoreCase(nameWithoutMacroMarker) ? new ContextMacro(macroNameWithMarker, macroContext, parameterPositionContext) : ("REF".equalsIgnoreCase(nameWithoutMacroMarker) ? new RefMacro(macroNameWithMarker, macroContext, parameterPositionContext) : ("DATE".equalsIgnoreCase(nameWithoutMacroMarker) && DATASET_MACRO_MARKER.equalsIgnoreCase(macroMarker) ? new DateMacro(macroNameWithMarker, macroContext, parameterPositionContext) : ("REF_DSL".equalsIgnoreCase(nameWithoutMacroMarker) ? new RefDslMacro(macroNameWithMarker, macroContext, parameterPositionContext) : ("REF_THIS".equalsIgnoreCase(nameWithoutMacroMarker) ? new RefThisMacro(macroNameWithMarker, macroContext, parameterPositionContext) : AbstractMacro.getAtpOrUnknownMacros(macroNameWithMarker, nameWithoutMacroMarker, macroContext, parameterPositionContext)))));
        macro.setOrder(parameterPositionContext.getOrder());
        macro.setEvaluate(evaluate);
        return macro;
    }

    abstract String getEvaluatedValue(List<String> var1);

    @Override
    public String getValue() {
        if (!this.isEvaluate()) {
            return this.getUnevaluatedValue(this.parameters);
        }
        try {
            String localValue = this.getEvaluatedValue(this.getArguments());
            TextParameterParser parser = new TextParameterParser(this.macroContext, this.parameterPositionContext);
            if (StringUtils.isEmpty((String)localValue)) {
                return localValue;
            }
            List<AbstractTextParameter> parsedResult = parser.parse(localValue, this.evaluate);
            StringBuilder result = new StringBuilder();
            for (AbstractTextParameter abstractTextParameter : parsedResult) {
                result.append(abstractTextParameter.getValue());
            }
            return result.toString();
        }
        catch (Exception e) {
            LOG.debug("Error macro evaluation", (Throwable)e);
            return "[Error macro evaluation]";
        }
    }

    public String getUnevaluatedValue(String childrenValue) {
        return this.macroNameWithMarker + "(" + StringUtils.defaultIfEmpty((String)childrenValue, (String)"") + ")";
    }

    @Override
    public boolean isNullValue() {
        return false;
    }

    private static AbstractMacro getAtpOrUnknownMacros(String name, String nameWithoutMacroMarker, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        Macros macros = AbstractMacro.getMacros(macroContext.getMacros(), nameWithoutMacroMarker);
        return Objects.nonNull(macros) ? new AtpMacro(name, macroContext, parameterPositionContext, macros) : new UnknownMacro(name, macroContext, parameterPositionContext);
    }

    @Nullable
    private static Macros getMacros(@Nonnull List<Macros> macroses, @Nonnull String key) {
        return macroses.stream().filter(macros -> key.equals(macros.getName())).findFirst().orElse(null);
    }

    public MacroContext getMacroContext() {
        return this.macroContext;
    }

    public ParameterPositionContext getParameterPositionContext() {
        return this.parameterPositionContext;
    }

    public void setEvaluate(boolean evaluate) {
        this.evaluate = evaluate;
    }

    public boolean isEvaluate() {
        return this.evaluate;
    }
}

