/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.rest.AttributeCreateResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/attribute"})
public class AttributeController {
    private final AttributeService attributeService;
    private final JpaAttributeService jpaAttributeService;
    private final DataSetListService dslService;
    private final ConcurrentModificationService concurrentModificationService;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'CREATE')")
    @PutMapping(value={"/dsl/{dataSetListId}"})
    @AuditAction(auditAction="Create new attribute with name: {{#name}} in dataset list: {{#dataSetListId}}")
    @Operation(summary="Creates new attribute with provided name and order.")
    public ResponseEntity<AttributeCreateResponse> create(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="name") String name, @RequestParam(value="ordering") Integer ordering, @RequestParam(value="type") AttributeTypeName attributeType, @RequestParam(value="typeDataSetListId", required=false) UUID typeDataSetListId, @RequestBody(required=false) List<String> listValues, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, HttpServletRequest request) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        org.qubership.atp.dataset.service.jpa.delegates.Attribute attribute = this.jpaAttributeService.create(name, attributeType, dataSetListId, typeDataSetListId, listValues);
        this.dslService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        List<ListValue> createdListValues = attribute.getListValues();
        List<AttributeCreateResponse.ListValue> listValuesUuid = createdListValues.stream().map(listValue -> new AttributeCreateResponse.ListValue(attribute.getId(), listValue.getId(), listValue.getText())).collect(Collectors.toList());
        AttributeCreateResponse createResponse = new AttributeCreateResponse(attribute.getId(), name, dataSetListId, attributeType, typeDataSetListId, listValuesUuid);
        StringBuffer url = request.getRequestURL();
        url.append("/").append(attribute.getId());
        URI uri = URI.create(url.toString());
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)httpStatus).location(uri)).body((Object)createResponse) : ResponseEntity.created((URI)uri).body((Object)createResponse);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'DELETE')")
    @DeleteMapping(value={"/{attributeId}"})
    @AuditAction(auditAction="Delete attribute: {{#attributeId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Deletes selected attribute.")
    public ResponseEntity<Boolean> delete(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.attributeService.delete(attributeId);
        this.dslService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'DELETE')")
    @DeleteMapping(value={"/dsl/{dataSetListId}/all"})
    @AuditAction(auditAction="Delete attributes in dataset list: {{#dataSetListId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Deletes attributes from the selected dataSetsList.")
    public ResponseEntity<Void> deleteAllByDsl(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        DataSetList dataSetList = (DataSetList)this.dslService.get(dataSetListId);
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        if (dataSetList != null) {
            for (Attribute attribute : dataSetList.getAttributes()) {
                this.attributeService.delete(attribute.getId());
            }
            this.attributeService.updateTypeDslId(dataSetListId, null);
            this.dslService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        }
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/dsl/{dataSetListId}"})
    @AuditAction(auditAction="Get attributes in dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns all attributes by dataSetList id.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Attribute.class)))})})
    public Collection<Attribute> getAttributes(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.attributeService.getByDslId(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/dsl/{dataSetListId}/itf"})
    @AuditAction(auditAction="attributes in ITF format from dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns all attributes by dataSetList id in itf format: [attr1.attr2, attr1].")
    public Object getAttributesInItfFormat(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.attributeService.getByDslIdInItfFormat(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{attributeId}"})
    @AuditAction(auditAction="Rename attribute: {{#attributeId}} on {{#name}}")
    @Operation(summary="Renames selected attribute.")
    public ResponseEntity<Boolean> rename(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="name") String name, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean isUpdated = this.attributeService.update(attributeId, name);
        if (Objects.nonNull(dataSetListId)) {
            this.dslService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        }
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)isUpdated) : ResponseEntity.ok((Object)isUpdated);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PutMapping(value={"/{attributeId}/dataSetListReference"})
    @AuditAction(auditAction="Update dataset list reference in attribute: {{#attributeId}}")
    @Operation(summary="Update DSL reference.")
    public ResponseEntity<Boolean> updateDslReference(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="value") UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"Referenced DSL uuid should not be null.");
        boolean isUpdated = this.attributeService.updateDslReference(attributeId, uuid);
        return ResponseEntity.ok((Object)isUpdated);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{attributeId}"})
    @AuditAction(auditAction="Update dataset list reference in attribute: {{#attributeId}}")
    @Operation(summary="Returns attribute.")
    public Attribute get(@PathVariable(value="attributeId") UUID attributeId) {
        return (Attribute)this.attributeService.get(attributeId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{attributeId}/options"})
    @AuditAction(auditAction="Get options attribute: {{#attributeId}}")
    public Object getOptions(@PathVariable(value="attributeId") UUID attributeId) {
        return this.attributeService.getOptions(attributeId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PutMapping(value={"/{attributeId}/listValues"})
    @AuditAction(auditAction="Create new list value for attribute: {{#attributeId}}")
    @Operation(summary="Creates new list value for provided attribute.")
    public ResponseEntity<org.qubership.atp.dataset.model.ListValue> createListValue(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="value") String value, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, HttpServletRequest request) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        org.qubership.atp.dataset.model.ListValue listValue = this.attributeService.createListValue(attributeId, value);
        StringBuffer url = request.getRequestURL();
        url.append("/").append(listValue.getId());
        URI uri = URI.create(url.toString());
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)httpStatus).location(uri)).body((Object)listValue) : ResponseEntity.created((URI)uri).body((Object)listValue);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{attributeId}/listValues"})
    @AuditAction(auditAction="Create new list values for attribute: {{#attributeId}} by text")
    @Operation(summary="Creates new list values for provided attribute by text.")
    public ResponseEntity<List<UUID>> createListValues(@PathVariable(value="attributeId") UUID attributeId, @RequestBody List<String> values, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        List<UUID> listValues = this.attributeService.createListValues(attributeId, values);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body(listValues) : ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(listValues);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @DeleteMapping(value={"/{attributeId}/listValues/{listValueId}"})
    @AuditAction(auditAction="Delete list value: {{#listValueId}} in attribute: {{#attributeId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete list value by id.")
    public ResponseEntity<Void> deleteListValue(@PathVariable(value="attributeId") UUID attributeId, @PathVariable(value="listValueId") UUID listValueId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.attributeService.deleteListValue(attributeId, listValueId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @DeleteMapping(value={"/{attributeId}/bulk"})
    @AuditAction(auditAction="Bulk delete list value: {{#listValueIds}} in attribute: {{#attributeId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Bulk delete list values by id.")
    public ResponseEntity<Void> bulkDeleteListValues(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="listValues") List<UUID> listValueIds, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.attributeService.deleteListValues(attributeId, listValueIds);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PutMapping(value={"/updateOrdering"})
    @AuditAction(auditAction="Update ordering of attributes")
    public void updateOrdering(@RequestBody List<Pair<UUID, Integer>> attributesOrdering) {
        this.attributeService.updateOrdering(attributesOrdering);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{attributeId}/position"})
    @AuditAction(auditAction="Set position of attribute: {{#attributeId}}")
    @Operation(summary="Creates new list values for provided attribute by text.")
    public void setPosition(@PathVariable(value="attributeId") UUID attributeId, @RequestBody Integer position) {
        this.jpaAttributeService.setPosition(attributeId, position);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@attributeServiceImpl.get(#targetAttrId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/{dataSetListId}/existedValues"})
    @AuditAction(auditAction="Get parameters value and datasets id of attribute: {{#targetAttrId}}")
    @Operation(summary="Sort Attribute values.")
    public Map<String, List<UUID>> getParametersValuesAndDataSetIdsForAttributeValuesSorting(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestBody(required=true) List<UUID> attrFilterIds, @RequestParam(value="targetAttrId", required=true) UUID targetAttrId) {
        UiManDataSetList tree = this.dslService.getAsTree(dataSetListId, false, null, Collections.singletonList(attrFilterIds.get(0)), null, null, false, true);
        return this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, dataSetListId, targetAttrId, attrFilterIds);
    }

    public AttributeController(AttributeService attributeService, JpaAttributeService jpaAttributeService, DataSetListService dslService, ConcurrentModificationService concurrentModificationService) {
        this.attributeService = attributeService;
        this.jpaAttributeService = jpaAttributeService;
        this.dslService = dslService;
        this.concurrentModificationService = concurrentModificationService;
    }
}

