/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.db.jpa.entities.AttributesSortType;
import org.qubership.atp.dataset.db.jpa.entities.UserSettingsEntity;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.rest.dto.manager.UserSettingsResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private final AttributeService attributeService;
    private final Provider<UserInfo> userInfoProvider;

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/current/settings"})
    @AuditAction(auditAction="Get current user settings")
    @Operation(summary="Gets current user settings.")
    public UserSettingsResponse getUserSettings() {
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        UserSettingsEntity sortEnabledEntity = this.attributeService.getAttributeSortConfigurationForUser(userId);
        boolean isSortEnabled = sortEnabledEntity != null && AttributesSortType.SORT_BY_NAME.equals((Object)sortEnabledEntity.getAttributesSortType());
        return new UserSettingsResponse(isSortEnabled);
    }

    public UserController(AttributeService attributeService, Provider<UserInfo> userInfoProvider) {
        this.attributeService = attributeService;
        this.userInfoProvider = userInfoProvider;
    }
}

