/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.ui;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.versioning.model.domain.AttributeKeySnapshot;

public class OverlapUiNode {
    private final UUID attributeId;
    private final String name;
    private final int level;
    private final Map<UUID, AttributeKeySnapshot> overLaps = new LinkedHashMap<UUID, AttributeKeySnapshot>();
    private final Map<UUID, OverlapUiNode> nodes = new LinkedHashMap<UUID, OverlapUiNode>();

    private OverlapUiNode(int level, String name, UUID attributeId) {
        this.attributeId = attributeId;
        this.name = name;
        this.level = level;
    }

    public static List<OverlapUiNode> getNodes(List<AttributeKeySnapshot> overlaps, ModelsProvider modelsProvider) {
        LinkedHashMap<UUID, OverlapUiNode> result = new LinkedHashMap<UUID, OverlapUiNode>();
        for (AttributeKeySnapshot overlap : overlaps) {
            List<UUID> attributePath = overlap.getAttributePath();
            if (attributePath.isEmpty()) continue;
            UUID attributePathId = attributePath.get(0);
            if (!result.containsKey(attributePathId)) {
                result.put(attributePathId, new OverlapUiNode(0, OverlapUiNode.getAttributeName(attributePathId, modelsProvider), attributePathId));
            }
            ((OverlapUiNode)result.get(attributePathId)).propagateAttributeKey(overlap, modelsProvider);
        }
        return new LinkedList<OverlapUiNode>(result.values());
    }

    private static String getAttributeName(UUID attributeId, ModelsProvider modelsProvider) {
        Attribute attribute = modelsProvider.getAttributeById(attributeId);
        if (attribute == null) {
            return "[NOT FOUND]";
        }
        return attribute.getName();
    }

    private void propagateAttributeKey(AttributeKeySnapshot overlap, ModelsProvider modelsProvider) {
        List<UUID> attributePath = overlap.getAttributePath();
        if (attributePath.size() == this.level + 1) {
            this.overLaps.put(overlap.getAttributeId(), overlap);
        } else if (!attributePath.isEmpty()) {
            UUID newAttributePathId = attributePath.get(this.level + 1);
            if (!this.nodes.containsKey(newAttributePathId)) {
                this.nodes.put(newAttributePathId, new OverlapUiNode(this.level + 1, OverlapUiNode.getAttributeName(newAttributePathId, modelsProvider), newAttributePathId));
            }
            this.nodes.get(newAttributePathId).propagateAttributeKey(overlap, modelsProvider);
        }
    }

    public List<AttributeKeySnapshot> getOverlapsList() {
        return new LinkedList<AttributeKeySnapshot>(this.overLaps.values());
    }

    public UUID getAttributeId() {
        return this.attributeId;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public Map<UUID, AttributeKeySnapshot> getOverLaps() {
        return this.overLaps;
    }

    public Map<UUID, OverlapUiNode> getNodes() {
        return this.nodes;
    }
}

