/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import java.util.UUID;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.metamodel.object.InstanceId;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class UpdateAttributeProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(UpdateAttributeProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<SetChange> setChangesDataSetListAttributes = UpdateAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, SetChange.class, "DataSetList", "attributes");
        if (!setChangesDataSetListAttributes.isEmpty()) {
            List addedAttributesIds = setChangesDataSetListAttributes.get(0).getAddedValues();
            return !addedAttributesIds.isEmpty();
        }
        return false;
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        SetChange changesList = UpdateAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, SetChange.class, "DataSetList", "attributes").get(0);
        InstanceId instanceId = (InstanceId)changesList.getAddedValues().get(0);
        UUID newAttributeId = (UUID)instanceId.getCdoId();
        String attributeName = UpdateAttributeProcessor.getAttributeById(actualEntity, newAttributeId).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.ADDED.toString());
        historyItem.setAttribute(attributeName);
        log.trace("Diff processed by NewAttributeChangeProcessor");
        return historyItem;
    }
}

