/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import java.util.UUID;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.Transactional;

@Configuration
@Import(value={TestConfiguration.class})
public class TransactionTestConfiguration {
    @Bean
    public DbUtils dbUtils() {
        return new DbUtils();
    }

    public static class DbUtils {
        @Autowired
        private AttributeService attributeService;
        @Autowired
        private DataSetListService dataSetListService;

        @Transactional
        public void operationsInTransaction(UUID attributeId, UUID dslId, String dslNameRenamed) {
            this.attributeService.delete(attributeId);
            this.dataSetListService.rename(dslId, dslNameRenamed);
        }
    }
}

