/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.dataset.config.TransactionTestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.VisibilityAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Disabled
@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TransactionTestConfiguration.class})
public class TransactionInterceptorTest {
    private final String dslName = "TransactionInterceptorTestDsl";
    private final String dslNameRenamed = "TransactionInterceptorTestDslAfterRename";
    @Autowired
    private VisibilityAreaService visibilityAreaService;
    @Autowired
    private DataSetListService dataSetListService;
    @Autowired
    private AttributeService attributeService;
    @Autowired
    private TransactionTestConfiguration.DbUtils dbUtils;
    @MockBean
    protected Encryptor encryptor;
    @MockBean
    protected Decryptor decryptor;
    private VisibilityArea va;
    private DataSetList dsl;
    private Attribute attributeOne;
    private Attribute attributeSecond;

    @BeforeEach
    public void setUp() {
        this.va = this.visibilityAreaService.create("TransactionInterceptorTestVa");
        this.dsl = this.dataSetListService.create(this.va.getId(), "TransactionInterceptorTestDsl", null);
        this.attributeOne = this.attributeService.create(this.dsl.getId(), Integer.valueOf(0), "TransactionInterceptorTestAttrOne", AttributeType.TEXT, null, null);
        this.attributeSecond = this.attributeService.create(this.dsl.getId(), Integer.valueOf(1), "TransactionInterceptorTestAttrSecond", AttributeType.TEXT, null, null);
    }

    @Test
    public void whenOperationsPassedThenCommitHappens() {
        Assertions.assertNotNull((Object)this.attributeOne);
        try {
            this.operationsInTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Attribute attribute = (Attribute)this.attributeService.get(this.attributeOne.getId());
        Assertions.assertNull((Object)attribute);
        String dslNameExpected = ((DataSetList)this.dataSetListService.get(this.dsl.getId())).getName();
        Assertions.assertEquals((Object)dslNameExpected, (Object)this.dslNameRenamed);
    }

    public void operationsInTransaction() {
        this.dbUtils.operationsInTransaction(this.attributeOne.getId(), this.dsl.getId(), "TransactionInterceptorTestDslAfterRename");
    }

    @AfterEach
    public void tearDown() {
        this.visibilityAreaService.delete(this.va.getId());
    }
}

