/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;

public class PhoneCallTestData
implements Supplier<VisibilityArea> {
    public final VisibilityArea va;
    public final DataSetList voiceCall;
    public final DataSet defaultVoiceCall;
    public final Parameter voiceCallIntoOriginCountryRef;
    public final Parameter voiceCallIntoDestinationCountryRef;
    public final DataSetList country;
    public final DataSet originCountry;
    public final DataSet destinationCountry;
    public final Attribute countryZone;
    public final Parameter originCountryZone;
    public final Parameter destinationCountryZone;
    public final DataSetList internationalRateCost;
    public final DataSet originCountryRate;
    public final Attribute targetCountryRate;
    public final Parameter rateCost;

    public PhoneCallTestData(@Nonnull CreationFacade create) {
        this.va = create.va("ATPII-3164");
        this.voiceCall = create.dsl(this.va, "Voice call");
        this.defaultVoiceCall = create.ds(this.voiceCall, "Default voice call");
        this.country = create.dsl(this.va, "Country");
        this.originCountry = create.ds(this.country, "France - Zone EU");
        this.originCountryZone = create.textParam(this.originCountry, "Zone", "Zone EU");
        this.countryZone = this.originCountryZone.getAttribute();
        this.destinationCountry = create.ds(this.country, "Belgium - Belgium");
        this.destinationCountryZone = create.textParam(this.destinationCountry, this.countryZone, "Belgium");
        this.voiceCallIntoOriginCountryRef = create.refParam(this.defaultVoiceCall, "OriginCountry", this.originCountry);
        this.voiceCallIntoDestinationCountryRef = create.refParam(this.defaultVoiceCall, "DestinationCountry", this.destinationCountry);
        this.internationalRateCost = create.dsl(this.va, "InternationalRateCost");
        this.originCountryRate = create.ds(this.internationalRateCost, "Zone EU");
        this.rateCost = create.textParam(this.originCountryRate, "Belgium", "-/-/0.08");
        this.targetCountryRate = this.rateCost.getAttribute();
    }

    @Override
    public VisibilityArea get() {
        return this.va;
    }
}

