/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.After;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.service.direct.helper.AbstractServicesInjected;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.DbCreationFacade;
import org.qubership.atp.dataset.service.direct.impl.ClearCacheServiceImpl;
import org.qubership.atp.dataset.utils.MutableSupplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@TestPropertySource(properties={"jdbc.leak.detection.threshold=10", "atp-dataset.last.revision.count=200", "atp-dataset.archive.job.bulk-delete-count=1000", "atp-dataset.archive.cron.expression=0 0 0 * * ?", "atp-dataset.archive.job.name=atp-dataset-archive-job", "atp-dataset.archive.job.page-size=50", "atp-dataset.archive.job.thread.max-pool-size=5", "atp-dataset.archive.job.thread.core-pool-size=5", "atp-dataset.archive.job.thread.queue-capacity=100"})
public abstract class AbstractTest
extends AbstractServicesInjected {
    @Autowired
    protected DbCreationFacade factory;
    protected VisibilityArea va;
    @MockBean
    protected Encryptor encryptor;
    @MockBean
    protected Decryptor decryptor;
    @MockBean
    ClearCacheServiceImpl clearCacheService;

    @Nonnull
    private static DataSetList getDataSetListByName(@Nonnull Collection<DataSetList> container, @Nonnull String name) {
        return container.stream().filter(dataSetList -> name.equals(dataSetList.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("DataSetList with name [" + name + "] was not found"));
    }

    protected VisibilityArea createTestData(Function<CreationFacade, VisibilityArea> data) {
        this.clearTestData();
        this.va = data.apply((CreationFacade)this.factory);
        return this.va;
    }

    protected <T extends Supplier<? extends VisibilityArea>> T createTestDataInstance(Function<CreationFacade, T> data) {
        MutableSupplier testDataSup = MutableSupplier.create();
        this.createTestData(facade -> {
            testDataSup.set((Object)((Supplier)data.apply((CreationFacade)facade)));
            return (VisibilityArea)((Supplier)testDataSup.get()).get();
        });
        return (T)((Supplier)testDataSup.get());
    }

    protected DataSetList getDataSetListByName(String name) {
        if (this.va != null) {
            return AbstractTest.getDataSetListByName(this.va.getDataSetLists(), name);
        }
        return AbstractTest.getDataSetListByName(this.dataSetListService.getAll(), name);
    }

    protected void clearTestData() {
        if (this.va != null) {
            this.visibilityAreaService.delete(this.va.getId());
        }
    }

    @After
    public final void after() {
        this.clearTestData();
    }

    protected List<DataSetListImpl> getResponse(String context) throws JSONException {
        List<String> json = this.getElements(context);
        return json.stream().map(this::deserialize).collect(Collectors.toList());
    }

    protected List<String> getElements(String context) throws JSONException {
        JSONArray jsonArray = new JSONArray(context);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.get(i).toString());
        }
        return list;
    }

    private DataSetListImpl deserialize(String context) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new TimestampDeserializer()).create();
        return (DataSetListImpl)gson.fromJson(context, new TypeToken<DataSetListImpl>(){}.getType());
    }

    private static class TimestampDeserializer
    implements JsonDeserializer<Timestamp> {
        private TimestampDeserializer() {
        }

        public Timestamp deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            return element == null ? null : new Timestamp(element.getAsLong());
        }
    }
}

