/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.direct.DuplicateKeyException;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.impl.DataSetBuilder;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;

@Isolated
@ContextConfiguration(classes={TestConfiguration.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class AttributeServiceImplTest
extends DataSetBuilder {
    private UUID dslId1;
    private UUID dslId2;
    private UUID dslId3;
    private UUID dsId11;
    private UUID dsId12;
    private UUID dsId21;
    private UUID dsId31;
    private UUID attrId11;
    private UUID attrId12;
    private UUID attrId13;
    private UUID attrId14;
    private UUID attrId15;
    private UUID attr22;
    private UUID attr31;

    @After
    public void tearDown() throws Exception {
        this.visibilityAreaService.delete(this.vaId);
    }

    @Test
    public void testRenameAttributeWillReplaceRefs() throws DuplicateKeyException {
        this.dataSetService.rename(this.dataSet1.getId(), "DataSet + MagicName");
        this.attributeService.update(this.attr.getId(), "Attribute");
        String stringValue = "#REF(DataSet + MagicName.Attribute) asd #REF(DataSet + MagicName.Attribute)";
        this.parameterService.update(this.source.getId(), stringValue);
        this.attributeService.update(this.attr.getId(), "SZ_UPDATED");
        Assertions.assertEquals((Object)"#REF(DataSet + MagicName.SZ_UPDATED) asd #REF(DataSet + MagicName.SZ_UPDATED)", (Object)this.wrapperService.unWrapAlias(((Parameter)this.parameterService.get(this.source.getId())).getText()));
    }

    @Test
    public void testRenameAttributeWillReplaceRefsDsl() throws DuplicateKeyException {
        this.dataSetService.rename(this.dataSet1.getId(), "DataSet + MagicName");
        this.attributeService.update(this.attr.getId(), "Attribute");
        this.dataSetListService.rename(this.dataSetList.getId(), "Input");
        String stringValue = "#REF(DataSet + MagicName.Attribute) #REF_DSL(Input.DataSet + MagicName.Attribute)";
        this.parameterService.update(this.source.getId(), stringValue);
        this.attributeService.update(this.attr.getId(), "SZ_UPDATED");
        Assertions.assertEquals((Object)"#REF(DataSet + MagicName.SZ_UPDATED) #REF_DSL(Input.DataSet + MagicName.SZ_UPDATED)", (Object)this.wrapperService.unWrapAlias(((Parameter)this.parameterService.get(this.source.getId())).getText()));
    }

    @Test
    public void testRenameAttributeWillNotReplaceRefsDslIfAttrNameMismatch() throws DuplicateKeyException {
        this.dataSetService.rename(this.dataSet1.getId(), "DataSet + MagicName");
        this.attributeService.update(this.attr.getId(), "Attribute");
        this.dataSetListService.rename(this.dataSetList.getId(), "Input");
        String stringValue = "#REF(DataSet + MagicName.Attribute1) #REF_DSL(Input.DataSet + MagicName.1Attribute)";
        this.parameterService.update(this.source.getId(), stringValue);
        this.attributeService.update(this.attr.getId(), "SZ_UPDATED");
        Assertions.assertEquals((Object)"#REF(DataSet + MagicName.Attribute1) #REF_DSL(Input.DataSet + MagicName.1Attribute)", (Object)this.wrapperService.unWrapAlias(((Parameter)this.parameterService.get(this.source.getId())).getText()));
    }

    @Test
    public void update_renameAttribute_attributeHaseTheSameOrdering() {
        int orderBefore = this.modelsProvider.getAttributeById(this.attr.getId()).getOrdering();
        this.attributeService.update(this.attr.getId(), "NewName");
        Assertions.assertEquals((int)orderBefore, (int)this.modelsProvider.getAttributeById(this.attr.getId()).getOrdering());
        Assertions.assertEquals((Object)"NewName", (Object)this.modelsProvider.getAttributeById(this.attr.getId()).getName());
    }

    @Test
    public void getAttrOptions_ReferenceAttr_ReferencesAreSorted() {
        MultipleRefOptions t = this.createTestDataInstance(MultipleRefOptions::new);
        UiManDataSetList er = new UiManDataSetList();
        er.setSource(t.childDsl);
        er.getDataSets().add(new UiManDataSet(t.dsA));
        er.getDataSets().add(new UiManDataSet(t.dsZ));
        Object ar = this.attributeService.getOptions(t.refAttr.getId());
        Assertions.assertEquals((Object)er, (Object)ar);
    }

    @Test
    public void deleteListValuesBulk_listValuesWereDeleted() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        Attribute beforeDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        ListValue listValue1 = (ListValue)beforeDeleting.getListValues().get(0);
        ListValue listValue2 = (ListValue)beforeDeleting.getListValues().get(1);
        Assertions.assertNotNull((Object)((Parameter)listValues.dsA.getParameters().get(0)).getListValue());
        Assertions.assertNotNull((Object)((Parameter)listValues.dsZ.getParameters().get(0)).getListValue());
        this.attributeService.deleteListValues(beforeDeleting.getId(), Arrays.asList(listValue1.getId(), listValue2.getId()));
        Attribute afterDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)afterDeleting.getListValues());
        Parameter after1 = (Parameter)this.parameterService.get(((Parameter)listValues.dsA.getParameters().get(0)).getId());
        Parameter after2 = (Parameter)this.parameterService.get(((Parameter)listValues.dsZ.getParameters().get(0)).getId());
        Assertions.assertNull((Object)after1.getListValue(), (String)"Parameter was not deleted, but lv is empty");
        Assertions.assertNull((Object)after2.getListValue(), (String)"Parameter was not deleted, but lv is empty");
    }

    @Test
    public void deleteListValue_deleteListValue1_listValue1WereDeleted() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        Attribute beforeDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        ListValue listValue1 = (ListValue)beforeDeleting.getListValues().get(0);
        ListValue listValue2 = (ListValue)beforeDeleting.getListValues().get(1);
        Assertions.assertEquals((int)beforeDeleting.getListValues().size(), (int)2);
        this.attributeService.deleteListValue(beforeDeleting.getId(), listValue1.getId());
        Attribute afterDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        Assertions.assertEquals((int)afterDeleting.getListValues().size(), (int)1);
        Assertions.assertNotEquals((Object)listValue1.getId(), (Object)((ListValue)afterDeleting.getListValues().get(0)).getId());
        Assertions.assertEquals((Object)listValue2.getId(), (Object)((ListValue)afterDeleting.getListValues().get(0)).getId());
    }

    @Test
    public void deleteListValue_deleteListValue1ForLockDs_listValue1NotDeleted() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        Attribute beforeDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        ListValue listValue1 = (ListValue)beforeDeleting.getListValues().get(0);
        this.dataSetService.lock(listValues.dsA.getDataSetList().getId(), Collections.singletonList(listValues.dsA.getId()), true);
        Assertions.assertEquals((int)beforeDeleting.getListValues().size(), (int)2);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.attributeService.deleteListValue(beforeDeleting.getId(), listValue1.getId()));
        }
        catch (IllegalArgumentException e) {
            Attribute afterDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
            Assertions.assertEquals((int)afterDeleting.getListValues().size(), (int)2);
            throw new IllegalArgumentException(e);
        }
    }

    @Test
    public void replaceListValues_replaceListValuesForLockDs_listValuesNotDeleted() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        Attribute beforeDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
        ListValue listValue1 = (ListValue)beforeDeleting.getListValues().get(0);
        ListValue listValue2 = (ListValue)beforeDeleting.getListValues().get(1);
        this.dataSetService.lock(listValues.dsA.getDataSetList().getId(), Collections.singletonList(listValues.dsA.getId()), true);
        Assertions.assertEquals((int)beforeDeleting.getListValues().size(), (int)2);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.attributeService.deleteListValues(beforeDeleting.getId(), Arrays.asList(listValue1.getId(), listValue2.getId())));
        }
        catch (IllegalArgumentException e) {
            Attribute afterDeleting = (Attribute)this.attributeService.get(listValues.listAttrId);
            Assertions.assertEquals((int)afterDeleting.getListValues().size(), (int)2);
            throw new IllegalArgumentException(e);
        }
    }

    @Test
    public void deleteListValue_deleteAttributeListValue_attributeHasOneListValue() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        Attribute attribute = (Attribute)this.attributeService.get(listValues.listAttrId);
        List lvsBefore = attribute.getListValues();
        this.attributeService.deleteListValue(listValues.listAttrId, ((ListValue)lvsBefore.get(0)).getId());
        attribute = (Attribute)this.attributeService.get(listValues.listAttrId);
        List lvsAfter = attribute.getListValues();
        Assertions.assertEquals((int)2, (int)lvsBefore.size());
        Assertions.assertEquals((int)1, (int)lvsAfter.size());
    }

    @Test
    public void createListValuesBulk_listValuesWereCreated() {
        ListValues listValues = this.createTestDataInstance(ListValues::new);
        this.attributeService.createListValues(listValues.listAttrId, Arrays.asList("456", "567"));
        Attribute attribute = (Attribute)this.attributeService.get(listValues.listAttrId);
        Assertions.assertEquals((Object)"456", (Object)((ListValue)attribute.getListValues().get(2)).getName());
        Assertions.assertEquals((Object)"567", (Object)((ListValue)attribute.getListValues().get(3)).getName());
    }

    @Test
    public void testUpdateDslReference_with1Level_checkOverlapsAreDeletedProperly() {
        MultipleRefOptions testData = this.createTestDataInstance(MultipleRefOptions::new);
        this.parameterService.set(testData.dsA.getId(), testData.textAttr.getId(), "ololo", Arrays.asList(testData.refAttr.getId()));
        boolean result = this.attributeService.updateDslReference(testData.refAttr.getId(), testData.childDsl2.getId());
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals(Collections.emptyList(), (Object)testData.textAttr.getParameters());
    }

    @Test
    public void testUpdateDslReference_with2Levels_checkOverlapsAreDeletedProperly() throws DuplicateKeyException {
        UUID visibilityAreaId = this.visibilityAreaService.create("ParameterServiceTestVa").getId();
        UUID postalCodeDataSetListId = this.dataSetListService.create(visibilityAreaId, "PostalCode", null).getId();
        DataSet postalCodeDataSet = this.dataSetService.create(postalCodeDataSetListId, "PC#1");
        Attribute codeAttribute = this.attributeService.create(postalCodeDataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String codeOriginalValue = "OriginalValue";
        this.parameterService.create(postalCodeDataSet.getId(), codeAttribute.getId(), codeOriginalValue, null, null);
        UUID addressDataSetList = this.dataSetListService.create(visibilityAreaId, "Address", null).getId();
        DataSet addressDataSet1 = this.dataSetService.create(addressDataSetList, "ADR#1");
        Attribute postalCodeReferenceAttribute = this.attributeService.create(addressDataSetList, Integer.valueOf(0), "PostalCodeRef", AttributeType.DSL, postalCodeDataSetListId, null);
        this.parameterService.create(addressDataSet1.getId(), postalCodeReferenceAttribute.getId(), null, null, postalCodeDataSet.getId());
        String codeOverlappedByAddressValue = "Overlapped by address";
        this.parameterService.set(addressDataSet1.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)postalCodeReferenceAttribute.getId()), codeOverlappedByAddressValue, null, null);
        UUID customerDataSetList = this.dataSetListService.create(visibilityAreaId, "Customer", null).getId();
        DataSet customerDataSet = this.dataSetService.create(customerDataSetList, "Customer1");
        Attribute addressReferenceAttribute = this.attributeService.create(customerDataSetList, Integer.valueOf(0), "AddressRef", AttributeType.DSL, addressDataSetList, null);
        this.parameterService.create(customerDataSet.getId(), addressReferenceAttribute.getId(), null, null, addressDataSet1.getId());
        String codeOverlappedByCustomerValue = "Overlapped by customer";
        this.parameterService.set(customerDataSet.getId(), codeAttribute.getId(), (List)ImmutableList.of((Object)addressReferenceAttribute.getId(), (Object)postalCodeReferenceAttribute.getId()), codeOverlappedByCustomerValue, null, null);
        Parameter actualCode = (Parameter)((OverlapItem)OverlapIterator.create((DataSet)customerDataSet, (UUID)codeAttribute.getId(), (Collection)ImmutableList.of((Object)addressReferenceAttribute.getId(), (Object)postalCodeReferenceAttribute.getId())).next()).getParameter().get();
        Assertions.assertEquals((Object)codeOverlappedByCustomerValue, (Object)actualCode.getText());
        UUID anotherPostalCodeDataSetListId = this.dataSetListService.create(visibilityAreaId, "PostalCode another", null).getId();
        DataSet anotherPostalCodeDataSet = this.dataSetService.create(anotherPostalCodeDataSetListId, "PC another#1");
        Attribute anotherCodeAttribute = this.attributeService.create(anotherPostalCodeDataSetListId, Integer.valueOf(0), "Code", AttributeType.TEXT, null, null);
        String anotherCodeOriginalValue = "Another OriginalValue";
        this.parameterService.create(anotherPostalCodeDataSet.getId(), anotherCodeAttribute.getId(), anotherCodeOriginalValue, null, null);
        customerDataSet = (DataSet)this.dataSetService.get(customerDataSet.getId());
        addressDataSet1 = (DataSet)this.dataSetService.get(addressDataSet1.getId());
        List beforeCustomersParametersList = customerDataSet.getParameters();
        Assertions.assertEquals((int)2, (int)beforeCustomersParametersList.size());
        List beforeAddressParametersList = addressDataSet1.getParameters();
        Assertions.assertEquals((int)2, (int)beforeAddressParametersList.size());
        this.attributeService.updateDslReference(postalCodeReferenceAttribute.getId(), anotherPostalCodeDataSetListId);
        customerDataSet = (DataSet)this.dataSetService.get(customerDataSet.getId());
        addressDataSet1 = (DataSet)this.dataSetService.get(addressDataSet1.getId());
        List afterDslUpdateParametersList = customerDataSet.getParameters();
        Assertions.assertEquals((int)1, (int)afterDslUpdateParametersList.size());
        List afterAddressParametersList = addressDataSet1.getParameters();
        Assertions.assertEquals((int)0, (int)afterAddressParametersList.size());
    }

    @Test
    public void getParametersAndDataSetIdsForAttributeSorting_testTextAttributeLevel1_ReturnDataSetIds() throws DuplicateKeyException {
        this.prepareDataForFilteringAttributeValues();
        UiManDataSetList tree = this.dataSetListService.getAsTree(this.dslId1, false, null, Collections.singletonList(this.attrId11), null, null, false, true);
        Map result = this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, this.dslId1, this.attrId11, Collections.singletonList(this.attrId11));
        List ids = (List)result.get("txt11");
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertTrue((boolean)ids.contains(this.dsId11));
    }

    @Test
    public void getParametersAndDataSetIdsForAttributeSorting_testTextAttributeTheSameParamValues_ReturnDataSetIds() throws DuplicateKeyException {
        this.prepareDataForFilteringAttributeValues();
        UiManDataSetList tree = this.dataSetListService.getAsTree(this.dslId1, false, null, Collections.singletonList(this.attrId15), null, null, false, true);
        Map result = this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, this.dslId1, this.attrId15, Collections.singletonList(this.attrId15));
        List ids = (List)result.get("txt15");
        Assertions.assertEquals((int)2, (int)ids.size());
        Assertions.assertTrue((boolean)ids.contains(this.dsId11));
        Assertions.assertTrue((boolean)ids.contains(this.dsId12));
    }

    @Test
    public void getParametersAndDataSetIdsForAttributeSorting_testMultiplyAttributeLevel1_ReturnDataSetIds() throws DuplicateKeyException {
        this.prepareDataForFilteringAttributeValues();
        UiManDataSetList tree = this.dataSetListService.getAsTree(this.dslId1, false, null, Collections.singletonList(this.attrId13), null, null, false, true);
        Map result = this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, this.dslId1, this.attrId13, Collections.singletonList(this.attrId13));
        List ids = (List)result.get("DS21");
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertTrue((boolean)ids.contains(this.dsId11));
    }

    @Test
    public void getParametersAndDataSetIdsForAttributeSorting_testListAttributeLevel1_ReturnDataSetIds() throws DuplicateKeyException {
        this.prepareDataForFilteringAttributeValues();
        UiManDataSetList tree = this.dataSetListService.getAsTree(this.dslId1, false, null, Collections.singletonList(this.attrId14), null, null, false, true);
        Map result = this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, this.dslId1, this.attrId14, Collections.singletonList(this.attrId14));
        List ids = (List)result.get("Link11");
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertTrue((boolean)ids.contains(this.dsId11));
    }

    @Test
    public void getParametersAndDataSetIdsForAttributeSorting_testDslAttributeLevel3_ReturnDataSetIds() throws DuplicateKeyException {
        this.prepareDataForFilteringAttributeValues();
        ArrayList<UUID> attrFilterIds = new ArrayList<UUID>();
        attrFilterIds.add(this.attrId12);
        attrFilterIds.add(this.attr22);
        UiManDataSetList tree = this.dataSetListService.getAsTree(this.dslId1, false, null, Collections.singletonList(this.attrId12), null, null, false, true);
        Map result = this.attributeService.getParametersAndDataSetIdsForAttributeSorting(tree, this.dslId1, this.attr31, attrFilterIds);
        List ids = (List)result.get("txt31");
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertTrue((boolean)ids.contains(this.dsId11));
    }

    private void prepareDataForFilteringAttributeValues() throws DuplicateKeyException {
        this.dslId1 = this.dataSetListService.create(this.vaId, "DSL1", null).getId();
        this.dslId2 = this.dataSetListService.create(this.vaId, "DSL2", null).getId();
        this.dslId3 = this.dataSetListService.create(this.vaId, "DSL3", null).getId();
        this.dsId11 = this.dataSetService.create(this.dslId1, "DS11").getId();
        this.dsId12 = this.dataSetService.create(this.dslId1, "DS12").getId();
        this.dsId21 = this.dataSetService.create(this.dslId2, "DS21").getId();
        this.dsId31 = this.dataSetService.create(this.dslId3, "DS31").getId();
        this.attrId11 = this.attributeService.create(this.dslId1, Integer.valueOf(1), "attr11", AttributeType.TEXT, null, null).getId();
        this.attrId12 = this.attributeService.create(this.dslId1, Integer.valueOf(2), "attr12", AttributeType.DSL, this.dslId2, null).getId();
        this.attrId13 = this.attributeService.create(this.dslId1, Integer.valueOf(3), "attr13", AttributeType.CHANGE, this.dslId2, null).getId();
        this.attrId15 = this.attributeService.create(this.dslId1, Integer.valueOf(4), "attr15", AttributeType.TEXT, null, null).getId();
        ArrayList<String> listValues = new ArrayList<String>();
        listValues.add("Link11");
        listValues.add("Link12");
        Attribute attr14 = this.attributeService.create(this.dslId1, Integer.valueOf(4), "attr14", AttributeType.LIST, null, listValues);
        this.attrId14 = attr14.getId();
        this.attr22 = this.attributeService.create(this.dslId2, Integer.valueOf(0), "attr21", AttributeType.DSL, this.dslId3, null).getId();
        this.attr31 = this.attributeService.create(this.dslId3, Integer.valueOf(0), "attr31", AttributeType.TEXT, null, null).getId();
        this.parameterService.create(this.dsId11, this.attrId11, "txt11", null, null).getId();
        this.parameterService.create(this.dsId11, this.attrId12, null, null, this.dsId21).getId();
        this.parameterService.create(this.dsId11, this.attrId13, "MULTIPLY " + this.dsId21, null, null).getId();
        this.parameterService.create(this.dsId11, this.attrId15, "txt15", null, null).getId();
        this.parameterService.create(this.dsId12, this.attrId15, "txt15", null, null).getId();
        this.parameterService.create(this.dsId11, this.attrId14, null, ((ListValue)attr14.getListValues().get(0)).getId(), null).getId();
        this.parameterService.create(this.dsId21, this.attr22, null, null, this.dsId31).getId();
        this.parameterService.create(this.dsId31, this.attr31, "txt31", null, null).getId();
    }

    private static class MultipleRefOptions
    implements Supplier<VisibilityArea> {
        public final Attribute refAttr;
        public final Attribute textAttr;
        private final VisibilityArea va;
        private final DataSetList parentDsl;
        private final DataSetList childDsl;
        private final DataSetList childDsl2;
        private final DataSet dsA;
        private final DataSet dsZ;
        private final DataSet dsB;

        public MultipleRefOptions(CreationFacade create) {
            this.va = create.va("ATPII-6329");
            this.parentDsl = create.dsl(this.va, "Parent DSL");
            this.childDsl = create.dsl(this.va, "Child DSL");
            this.childDsl2 = create.dsl(this.va, "Child DSL 2");
            this.dsZ = create.ds(this.childDsl, "Z");
            this.dsA = create.ds(this.childDsl, "A");
            this.dsB = create.ds(this.childDsl2, "B");
            this.refAttr = create.refAttr(this.parentDsl, "ref", this.childDsl);
            this.textAttr = create.textAttr(this.childDsl, "Text attr");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }

    private static class ListValues
    implements Supplier<VisibilityArea> {
        private final VisibilityArea va;
        private final DataSetList parentDsl;
        private final DataSet dsA;
        private final DataSet dsZ;
        private final UUID listAttrId;

        public ListValues(CreationFacade create) {
            this.va = create.va("ATPII-9090");
            this.parentDsl = create.dsl(this.va, "Parent DSL");
            this.dsZ = create.ds(this.parentDsl, "Z");
            this.dsA = create.ds(this.parentDsl, "A");
            Attribute listAttr = create.listAttr(this.parentDsl, "ref", new String[]{"123", "234"});
            this.listAttrId = listAttr.getId();
            create.listParam(this.dsA, listAttr, "123");
            create.listParam(this.dsZ, listAttr, "234");
        }

        @Override
        public VisibilityArea get() {
            return this.va;
        }
    }
}

