/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.List;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractMacroTest;

@Isolated
public class MacrosTest
extends AbstractMacroTest {
    @Test
    public void TestMacro_InnMacro_result() {
        String parameterValue = "#INN()";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Pattern pattern = Pattern.compile("[0-9]{10}");
        Assertions.assertTrue((boolean)pattern.matcher(result.toString()).matches());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_RefThisMacro_result() {
        String parameterValue = "#REF_THIS(dsl_reference.attribute_id)";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)"MY TEXT", (Object)result.toString());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_RefMacro_result() {
        String parameterValue = "#REF(dsl_reference.attribute_id)";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)"MY TEXT", (Object)result.toString());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_RefDslMacro_result() {
        String parameterValue = "#REF_DSL(dsl_id.dsl_reference.attribute_id)";
        List parseEvaluatedResult = this.parser.parse(parameterValue, true);
        StringBuilder evaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseEvaluatedResult) {
            evaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)"MY TEXT", (Object)evaluatedResult.toString());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_UuidMacro_result() {
        String parameterValue = "#UUID()";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertTrue((boolean)Utils.isUuid((Object)result.toString()));
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_UnknownMacro_result() {
        String parameterValue = "#DUNNO()";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_CharsMacro_result() {
        String parameterValue = "#CHARS(10)";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Pattern pattern = Pattern.compile("[a-z]{10}");
        Assertions.assertTrue((boolean)pattern.matcher(result.toString()).matches());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_CharsUpperMacro_result() {
        String parameterValue = "#CHARS_UPPERCASE(10)";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Pattern pattern = Pattern.compile("[A-Z]{10}");
        Assertions.assertTrue((boolean)pattern.matcher(result.toString()).matches());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_RandomBetween_result() {
        String parameterValue = "#RANDBETWEEN(100,1000)";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)result.toString());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }

    @Test
    public void TestMacro_Rand_result() {
        String parameterValue = "#RAND('5')";
        List parseResult = this.parser.parse(parameterValue, true);
        StringBuilder result = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseResult) {
            result.append(abstractTextParameter.getValue());
        }
        Pattern pattern = Pattern.compile("[0-9]{5}");
        Assertions.assertTrue((boolean)pattern.matcher(result.toString()).matches());
        List parseUnevaluatedResult = this.parser.parse(parameterValue, false);
        StringBuilder unevaluatedResult = new StringBuilder();
        for (AbstractTextParameter abstractTextParameter : parseUnevaluatedResult) {
            unevaluatedResult.append(abstractTextParameter.getValue());
        }
        Assertions.assertEquals((Object)parameterValue, (Object)unevaluatedResult.toString());
    }
}

