/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ui;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.qubership.atp.dataset.config.IntegrationTestConfiguration;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.service.AbstractTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={IntegrationTestConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class AbstractIntegrationCase
extends AbstractTest {
    protected static String serverBaseUrl;
    protected String httpsPort;
    protected String httpPort;
    @Value(value="${service.https.enabled}")
    private String httpsEnabled;
    @Autowired
    public Properties properties;
    @Autowired
    private Environment serverEnvironment;

    @BeforeEach
    public void before() throws UnknownHostException {
        serverBaseUrl = this.properties.getProperty("server.url");
        if (serverBaseUrl == null) {
            this.httpsPort = this.serverEnvironment.getProperty("https.port");
            this.httpPort = this.serverEnvironment.getProperty("local.server.port");
            String hostName = System.getProperty("COMPUTERNAME") != null ? System.getProperty("COMPUTERNAME") : InetAddress.getLocalHost().getHostAddress();
            serverBaseUrl = Boolean.parseBoolean(this.httpsEnabled) ? "https://" + hostName + ":" + this.httpsPort : "http://" + hostName + ":" + this.httpPort;
        }
    }
}

