/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config.interceptors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class HttpResponseLogging
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseLogging.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String endpoint = request.getURI().getPath();
        HttpMethod method = request.getMethod();
        if (endpoint.contains("/atp") || endpoint.contains("/itf")) {
            String message = "Send response to request by URL  \"" + endpoint + "\" Method: \"" + method.name() + "\"";
            log.info(message);
        }
        return body;
    }
}

