/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.db.LabelRepository;
import org.qubership.atp.dataset.db.TestPlanRepository;
import org.qubership.atp.dataset.db.VisibilityAreaRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.AffectedDataSetList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DataSetListRepository
extends AbstractRepository {
    private final DataSetListProjection dslProjection;
    private final SQLQueryFactory queryFactory;
    private final Provider<DataSetRepository> dsRepo;
    private final Provider<AttributeRepository> attrRepo;
    private final Provider<LabelRepository> labelRepo;
    private final Provider<VisibilityAreaRepository> vaRepo;
    private final Provider<TestPlanRepository> testPlanRepo;
    private final CacheRepository cacheRepo;

    @Autowired
    public DataSetListRepository(@Nonnull SQLQueryFactory queryFactory, @Nonnull Provider<VisibilityAreaRepository> vaRepo, @Nonnull Provider<DataSetRepository> dsRepo, @Nonnull Provider<AttributeRepository> attrRepo, @Nonnull Provider<LabelRepository> labelRepo, @Nonnull CacheRepository cacheRepo, @Nonnull Provider<TestPlanRepository> testPlanRepo) {
        this.queryFactory = queryFactory;
        this.vaRepo = vaRepo;
        this.dsRepo = dsRepo;
        this.attrRepo = attrRepo;
        this.labelRepo = labelRepo;
        this.cacheRepo = cacheRepo;
        this.testPlanRepo = testPlanRepo;
        this.dslProjection = new DataSetListProjection(this);
    }

    @Nonnull
    public DataSetList create(@Nonnull UUID visibilityAreaId, @Nonnull String name, @Nullable UUID testPlanId, @Nonnull UUID createdBy, @Nonnull Timestamp createdWhen) {
        UUID dataSetListId = (UUID)Preconditions.checkNotNull((Object)((UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)DSL).set(DataSetListRepository.DSL.visibilityAreaId, (Object)visibilityAreaId)).set((Path)DataSetListRepository.DSL.name, (Object)name)).set(DataSetListRepository.DSL.testPlanId, (Object)testPlanId)).set(DataSetListRepository.DSL.createdBy, (Object)createdBy)).set(DataSetListRepository.DSL.createdWhen, (Object)createdWhen)).set(DataSetListRepository.DSL.modifiedBy, (Object)createdBy)).set(DataSetListRepository.DSL.modifiedWhen, (Object)createdWhen)).executeWithKey(DataSetListRepository.DSL.id)), (Object)"nothing created");
        Preconditions.checkNotNull((Object)dataSetListId, (Object)"nothing created");
        return this.dslProjection.create(dataSetListId, name, visibilityAreaId, testPlanId, createdBy, createdWhen, createdBy, createdWhen);
    }

    @Nullable
    public DataSetList getById(@Nonnull UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(DataSetList.class, id, uuid -> (DataSetList)this.select((Predicate)DataSetListRepository.DSL.id.eq(uuid)).fetchOne());
    }

    @Nonnull
    public List<DataSetList> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.dslProjection).from((Expression)DSL)).fetch();
    }

    @Nonnull
    public List<DataSetList> getAll(@Nonnull UUID visibilityArea) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.dslProjection).from((Expression)DSL)).where((Predicate)DataSetListRepository.DSL.visibilityAreaId.eq((Object)visibilityArea))).fetch();
    }

    @Nonnull
    public List<DataSetList> getAll(@Nonnull List<UUID> datasetListIds) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.dslProjection).from((Expression)DSL)).where((Predicate)DataSetListRepository.DSL.id.in(datasetListIds))).fetch();
    }

    @Nonnull
    protected SQLQuery<DataSetList> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.dslProjection).from((Expression)DSL)).where(predicate);
    }

    public boolean rename(@Nonnull UUID id, @Nonnull String name, UUID modifiedBy, Timestamp modifiedWhen) {
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DSL).where((Predicate)DataSetListRepository.DSL.id.eq((Object)id))).set((Path)DataSetListRepository.DSL.name, (Object)name)).set(DataSetListRepository.DSL.modifiedBy, (Object)modifiedBy)).set(DataSetListRepository.DSL.modifiedWhen, (Object)modifiedWhen)).execute();
        return this.entitiesWasUpdated(update);
    }

    public boolean setTestPlan(@Nonnull UUID id, @Nullable UUID testPlanId, UUID modifiedBy, Timestamp modifiedWhen) {
        long update = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DSL).where((Predicate)DataSetListRepository.DSL.id.eq((Object)id))).set(DataSetListRepository.DSL.testPlanId, (Object)testPlanId)).set(DataSetListRepository.DSL.modifiedBy, (Object)modifiedBy)).set(DataSetListRepository.DSL.modifiedWhen, (Object)modifiedWhen)).execute();
        return this.entitiesWasUpdated(update);
    }

    private boolean entitiesWasUpdated(long amount) {
        return amount > 0L;
    }

    void onVaDeleteCascade(UUID vaId) {
        this.getAll(vaId).forEach(dsl -> this.delete(dsl.getId()));
    }

    public boolean delete(@Nonnull UUID id) {
        ((AttributeRepository)this.attrRepo.get()).onDslDeleteCascade(id);
        ((DataSetRepository)this.dsRepo.get()).onDslDeleteCascade(id);
        ((LabelRepository)this.labelRepo.get()).onDslDeleteCascade(id);
        return this.delete((Predicate)DataSetListRepository.DSL.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)DSL).where(predicate)).execute();
    }

    public DataSetList getByNameUnderVisibilityArea(UUID visibilityArea, String name) {
        return (DataSetList)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.dslProjection).from((Expression)DSL)).where((Predicate)DataSetListRepository.DSL.visibilityAreaId.eq((Object)visibilityArea).and((Predicate)DataSetListRepository.DSL.name.eq((Object)name)))).fetchOne();
    }

    @Nonnull
    public Label mark(@Nonnull UUID dslId, @Nonnull String labelName, UUID modifiedBy, Timestamp modifiedWhen) {
        Label label = ((LabelRepository)this.labelRepo.get()).markDsl(dslId, labelName);
        this.updateModifiedFields(dslId, modifiedBy, modifiedWhen);
        return label;
    }

    public boolean unmark(@Nonnull UUID dslId, @Nonnull UUID labelId, UUID modifiedBy, Timestamp modifiedWhen) {
        boolean unmark = ((LabelRepository)this.labelRepo.get()).unmarkDsl(dslId, labelId);
        if (unmark) {
            this.updateModifiedFields(dslId, modifiedBy, modifiedWhen);
        }
        return unmark;
    }

    @Nonnull
    public List<Label> getLabels(@Nonnull UUID dslId) {
        return ((LabelRepository)this.labelRepo.get()).getLabelsOfDsl(dslId);
    }

    @Nonnull
    public List<DataSetList> getAllByLabel(@Nonnull UUID visibilityArea, @Nonnull String labelName) {
        return this.select((Predicate)DataSetListRepository.DSL.visibilityAreaId.eq((Object)visibilityArea).and((Predicate)((LabelRepository)this.labelRepo.get()).dslByLabelName(labelName))).fetch();
    }

    public List<DataSetList> getUnderTestPlan(UUID testPlanId) {
        return this.select((Predicate)DataSetListRepository.DSL.testPlanId.eq((Object)testPlanId)).fetch();
    }

    public void onTestPlanDeleteCascade(UUID testPlanId, UUID modifiedBy, Timestamp modifiedWhen) {
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DSL).where((Predicate)DataSetListRepository.DSL.testPlanId.eq((Object)testPlanId))).set(DataSetListRepository.DSL.testPlanId, (Object)null)).set(DataSetListRepository.DSL.modifiedBy, (Object)modifiedBy)).set(DataSetListRepository.DSL.modifiedWhen, (Object)modifiedWhen)).execute();
    }

    public void updateModifiedFields(UUID dataSetListId, UUID modifiedBy, Timestamp modifiedWhen) {
        ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)DSL).where((Predicate)DataSetListRepository.DSL.id.eq((Object)dataSetListId))).set(DataSetListRepository.DSL.modifiedBy, (Object)modifiedBy)).set(DataSetListRepository.DSL.modifiedWhen, (Object)modifiedWhen)).execute();
    }

    public List<TableResponse> getAffectedAttributes(UUID dataSetListId, Integer page, Integer size) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{DataSetListRepository.DSL.id, DataSetListRepository.DSL.name, DataSetListRepository.ATTR.id, DataSetListRepository.ATTR.name}).from((Expression)ATTR)).where((Predicate)DataSetListRepository.ATTR.typeDatasetlistId.eq((Object)dataSetListId))).leftJoin((EntityPath)DSL)).on((Predicate)DataSetListRepository.ATTR.datasetlistId.eq(DataSetListRepository.DSL.id));
        if (Objects.nonNull(page) && Objects.nonNull(size)) {
            ((SQLQuery)query.offset((long)(page * size))).limit((long)size.intValue());
        }
        return query.fetch().stream().map(TableResponse::fromParameterTuple).collect(Collectors.toList());
    }

    public boolean existsById(@Nonnull UUID dataSetListId) {
        DataSetList dataSetList = this.getById(dataSetListId);
        return Objects.nonNull(dataSetList);
    }

    public List<AffectedDataSetList> getAffectedDataSetLists(UUID dataSetListId, Integer limit, Integer offset) {
        List result = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{DataSetListRepository.DSL.id, DataSetListRepository.DSL.name}).from((Expression)ATTR)).where((Predicate)DataSetListRepository.ATTR.typeDatasetlistId.eq((Object)dataSetListId))).innerJoin((EntityPath)DSL)).on((Predicate)DataSetListRepository.ATTR.datasetlistId.eq(DataSetListRepository.DSL.id))).groupBy(new Expression[]{DataSetListRepository.DSL.id, DataSetListRepository.DSL.name})).orderBy(DataSetListRepository.DSL.name.asc())).limit((long)limit.intValue())).offset((long)offset.intValue())).fetch();
        return result.stream().map(AffectedDataSetList::fromTuple).collect(Collectors.toList());
    }

    public Timestamp getModifiedWhen(UUID dataSetListId) {
        return (Timestamp)((SQLQuery)((SQLQuery)this.queryFactory.select(DataSetListRepository.DSL.modifiedWhen).from((Expression)DSL)).where((Predicate)DataSetListRepository.DSL.id.eq((Object)dataSetListId))).fetchOne();
    }

    private static class DataSetListProjection
    extends MappingProjection<DataSetList> {
        private final DataSetListRepository repo;

        private DataSetListProjection(DataSetListRepository repo) {
            super(DataSetList.class, (Expression[])AbstractRepository.DSL.all());
            this.repo = repo;
        }

        protected DataSetListImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.DSL.id);
            Preconditions.checkNotNull((Object)id);
            UUID vaId = (UUID)row.get(AbstractRepository.DSL.visibilityAreaId);
            Preconditions.checkNotNull((Object)vaId);
            UUID testPlanId = (UUID)row.get(AbstractRepository.DSL.testPlanId);
            String name = (String)row.get((Expression)AbstractRepository.DSL.name);
            Preconditions.checkNotNull((Object)name);
            Timestamp createdWhen = (Timestamp)row.get(AbstractRepository.DSL.createdWhen);
            UUID createdBy = (UUID)row.get(AbstractRepository.DSL.createdBy);
            Timestamp modifiedWhen = (Timestamp)row.get(AbstractRepository.DSL.modifiedWhen);
            UUID modifiedBy = (UUID)row.get(AbstractRepository.DSL.modifiedBy);
            return this.create(id, name, vaId, testPlanId, createdBy, createdWhen, modifiedBy, modifiedWhen);
        }

        private DataSetListImpl create(@Nonnull UUID dataSetListId, @Nonnull String name, @Nonnull UUID visibilityAreaId, @Nullable UUID testPlanId, UUID createdBy, Timestamp createdWhen, UUID modifiedBy, Timestamp modifiedWhen) {
            VisibilityArea va = Proxies.withId(VisibilityArea.class, visibilityAreaId, uuid -> ((VisibilityAreaRepository)this.repo.vaRepo.get()).getById((UUID)uuid));
            List dataSets = Proxies.list(() -> ((DataSetRepository)this.repo.dsRepo.get()).getByParentId(dataSetListId));
            final AttributeRepository attrRepo = (AttributeRepository)this.repo.attrRepo.get();
            List attrs = Proxies.list(() -> attrRepo.getByParentId(dataSetListId));
            List labels = Proxies.list(() -> ((LabelRepository)this.repo.labelRepo.get()).getLabelsOfDsl(dataSetListId));
            TestPlan testPlan = null;
            if (testPlanId != null) {
                testPlan = Proxies.withId(TestPlan.class, testPlanId, uuid -> ((TestPlanRepository)this.repo.testPlanRepo.get()).getById((UUID)uuid));
            }
            return new DataSetListImpl(dataSetListId, va, name, dataSets, attrs, labels, testPlan, createdBy, createdWhen, modifiedBy, modifiedWhen){

                @Override
                @Nonnull
                public Collection<Attribute> getAttributes(@Nonnull AttributeType type) {
                    return attrRepo.getByParentId(this.id, type);
                }
            };
        }
    }
}

