/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.qubership.atp.dataset.db.jdbc.JdbcTemplates;
import org.qubership.atp.dataset.db.jdbc.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdbcTemplatesImpl
implements JdbcTemplates {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcTemplatesImpl.class);
    @Autowired
    public DataSource dataSource;

    @Override
    public <T> T executeSelect(String querySql, ResultSetHandler<T> handler, Object ... params) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(querySql);
            for (int i = 0; i < params.length; ++i) {
                preparedStatement.setObject(i + 1, params[i]);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            T t = handler.onResultSet(resultSet);
            return t;
        }
        catch (SQLException e) {
            LOG.error("Error query execution '" + querySql + "'", (Throwable)e);
            throw new RuntimeException("Error query execution", e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.error("Error closing connection", (Throwable)e);
            }
        }
    }
}

