/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.LabelEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributeKeyRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributeRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaAttributeTypeRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetListRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaListValueRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaParameterRepository;
import org.qubership.atp.dataset.db.jpa.repositories.JpaVisibilityAreaRepository;
import org.qubership.atp.dataset.exception.dataset.DataSetNotFoundException;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Label;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.rest.PaginationResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.AbstractEntityResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ModelsProvider {
    @Autowired
    protected JpaDataSetListRepository dataSetListRepository;
    @Autowired
    protected JpaDataSetRepository dataSetRepository;
    @Autowired
    protected JpaAttributeRepository attributeRepository;
    @Autowired
    protected JpaAttributeKeyRepository attributeKeyRepository;
    @Autowired
    protected JpaVisibilityAreaRepository visibilityAreaRepository;
    @Autowired
    protected JpaParameterRepository parameterRepository;
    @Autowired
    protected JpaListValueRepository listValueRepository;
    @Autowired
    protected JpaAttributeTypeRepository attributeTypeRepository;

    public DataSetList getDataSetListById(UUID uuid) {
        Optional<DataSetListEntity> dataSetListOptional = this.dataSetListRepository.findById(uuid);
        return dataSetListOptional.map(this::getDataSetList).orElse(null);
    }

    public Page<AttributeEntity> getAttributesPageableByDslId(UUID uuid, List<AttributeTypeName> attributeTypesToLoad, Pageable pageable) {
        List<Long> typeIds = attributeTypesToLoad.stream().map(AttributeTypeName::getId).toList();
        Page<AttributeEntity> byEntityAndTypeIds = this.attributeRepository.findByEntityAndTypeIds(uuid, typeIds, pageable);
        return byEntityAndTypeIds;
    }

    public List<VisibilityArea> getAllVisibilityAreas() {
        LinkedList<VisibilityArea> result = new LinkedList<VisibilityArea>();
        this.visibilityAreaRepository.findAll().forEach(visibilityAreaEntity -> result.add(this.getVisibilityArea((AbstractUuidBasedEntity)visibilityAreaEntity)));
        return result;
    }

    public List<VisibilityArea> getAllVisibilityAreasOrderedByNameAsc() {
        LinkedList<VisibilityArea> result = new LinkedList<VisibilityArea>();
        this.visibilityAreaRepository.findAllByOrderByNameAsc().forEach(visibilityAreaEntity -> result.add(this.getVisibilityArea((AbstractUuidBasedEntity)visibilityAreaEntity)));
        return result;
    }

    public Attribute getAttributeById(UUID uuid) {
        Optional dataSetListOptional = this.attributeRepository.findById(uuid);
        return dataSetListOptional.map(this::getAttribute).orElse(null);
    }

    @Cacheable(value={"ATP_DATASETS_PARAMETER_CACHE"}, key="#uuid")
    public Parameter getParameterById(UUID uuid) {
        Optional dataSetListOptional = this.parameterRepository.findById(uuid);
        return dataSetListOptional.map(this::getParameter).orElse(null);
    }

    public Parameter getParameterByAttributeIdAndDataSetId(UUID attributeId, UUID dataSetId) {
        ParameterEntity parameterEntity = this.parameterRepository.getByAttributeIdAndDataSet_Id(attributeId, dataSetId);
        return this.getParameter(parameterEntity);
    }

    public DataSet getDataSetById(UUID uuid) {
        Optional<DataSetEntity> dataSetOptional = this.dataSetRepository.findById(uuid);
        return dataSetOptional.map(this::getDataSet).orElse(null);
    }

    public List<DataSet> getDataSetByNameAndDataSetListId(String name, UUID uuid) {
        List<DataSetEntity> dataSetOptional = this.dataSetRepository.findByNameAndDataSetListId(name, uuid);
        return dataSetOptional.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<DataSet> getDataSetByDataSetListId(UUID uuid) {
        List<DataSetEntity> dataSetOptional = this.dataSetRepository.findByDataSetListId(uuid);
        return dataSetOptional.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<DataSet> getDatasetsByDataSetListId(UUID dataSetListId) {
        List<DataSetEntity> dataSetEntities = this.dataSetRepository.findByDataSetListId(dataSetListId);
        return dataSetEntities.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<Attribute> getAttributesByDataSetListId(UUID dataSetListId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getByDataSetListId(dataSetListId);
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<Attribute> getAttributesByDataSetListIdIn(Collection<UUID> dataSetListIds) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getByDataSetListIdIn(dataSetListIds);
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<DataSet> getDataSetBySourceAndDataSetListId(UUID sourceId, UUID datasetId) {
        List<DataSetEntity> dataSetOptional = this.dataSetRepository.findBySourceIdAndDataSetListId(sourceId, datasetId);
        return dataSetOptional.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public VisibilityArea getVisibilityAreaById(UUID uuid) {
        Optional<VisibilityAreaEntity> visibilityAreaOptional = this.visibilityAreaRepository.findById(uuid);
        return visibilityAreaOptional.map(this::getVisibilityArea).orElse(null);
    }

    public VisibilityArea getVisibilityAreaByName(String name) {
        VisibilityAreaEntity visibilityAreaEntity = this.visibilityAreaRepository.findByName(name);
        return this.getVisibilityArea(visibilityAreaEntity);
    }

    public VisibilityArea createVisibilityArea(String name) {
        VisibilityAreaEntity newArea = new VisibilityAreaEntity();
        newArea.setName(name);
        VisibilityAreaEntity saved = (VisibilityAreaEntity)this.visibilityAreaRepository.save(newArea);
        return this.getVisibilityArea(saved);
    }

    public VisibilityArea replicate(UUID id, String name) {
        VisibilityAreaEntity newArea = new VisibilityAreaEntity();
        newArea.setName(name);
        newArea.setId(id);
        VisibilityArea area = this.getVisibilityArea(newArea);
        area.replicate();
        return this.getVisibilityAreaById(id);
    }

    public Attribute getAttribute(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new Attribute((AttributeEntity)entity);
    }

    public AttributeKey getAttributeKey(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new AttributeKey((AttributeKeyEntity)entity);
    }

    public AttributeKey getAttributeKeyById(UUID id) {
        Optional attributeKey = this.attributeKeyRepository.findById(id);
        return this.getAttributeKey(attributeKey.orElse(null));
    }

    public List<AttributeKey> getByDataSetListId(UUID dataSetListId) {
        List<AttributeKeyEntity> attributeKeys = this.attributeKeyRepository.getByDataSetListId(dataSetListId);
        if (CollectionUtils.isEmpty(attributeKeys)) {
            return Collections.emptyList();
        }
        return attributeKeys.stream().map(this::getAttributeKey).collect(Collectors.toList());
    }

    public DataSet getDataSet(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new DataSet((DataSetEntity)entity);
    }

    public DataSetList getDataSetList(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new DataSetList((DataSetListEntity)entity);
    }

    public Label getLabel(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new Label((LabelEntity)entity);
    }

    public Parameter getParameter(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new Parameter((ParameterEntity)entity);
    }

    public VisibilityArea getVisibilityArea(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new VisibilityArea((VisibilityAreaEntity)entity);
    }

    public ListValue getListValue(AbstractUuidBasedEntity entity) {
        if (entity == null) {
            return null;
        }
        return new ListValue((ListValueEntity)entity);
    }

    public Page<AbstractEntityResponse> getDatasetsIdNamesPageByNameAndVaId(String name, UUID visibilityAreaId, Pageable pageable) {
        VisibilityAreaEntity visibilityAreaEntity = new VisibilityAreaEntity();
        visibilityAreaEntity.setId(visibilityAreaId);
        List<UUID> dataSetListsId = this.dataSetListRepository.findByVisibilityArea(visibilityAreaEntity).stream().map(AbstractUuidBasedEntity::getId).collect(Collectors.toList());
        return this.dataSetRepository.findAllByNameContainsAndDslIn(name, dataSetListsId, pageable).orElse((Page<DataSetEntity>)new PageImpl(Collections.emptyList(), pageable, 0L)).map(dataSetEntity -> new AbstractEntityResponse(dataSetEntity.getId(), dataSetEntity.getName()));
    }

    public ListValue getListValueById(UUID id) {
        if (id == null) {
            return null;
        }
        ListValueEntity entity = this.listValueRepository.getById(id);
        return new ListValue(entity);
    }

    public Page<DataSetEntity> getAllNamesByName(String name, Pageable pageable) {
        return this.dataSetRepository.findAllByNameContains(name, pageable);
    }

    public DataSetList replicateDataSetList(UUID id, String name, UUID visibilityAreaId, UUID sourceId, UUID createdBy, Timestamp createdWhen, UUID modifiedBy, Timestamp modifiedWhen) throws DataSetServiceException {
        DataSetListEntity dataSetListEntity = new DataSetListEntity();
        dataSetListEntity.setName(name);
        dataSetListEntity.setId(id);
        dataSetListEntity.setSourceId(sourceId);
        dataSetListEntity.setCreatedBy(createdBy);
        dataSetListEntity.setCreatedWhen(createdWhen);
        dataSetListEntity.setModifiedBy(modifiedBy);
        dataSetListEntity.setModifiedWhen(modifiedWhen);
        Optional<VisibilityAreaEntity> visibilityArea = this.visibilityAreaRepository.findById(visibilityAreaId);
        if (!visibilityArea.isPresent()) {
            throw new DataSetServiceException("Visibility Area with id " + visibilityAreaId + " not found");
        }
        dataSetListEntity.setVisibilityArea(visibilityArea.get());
        DataSetList area = this.getDataSetList(dataSetListEntity);
        area.replicate();
        return area;
    }

    public DataSet replicateDataSet(UUID id, String name, UUID dataSetListId, Long ordering, UUID sourceId, Boolean isLocked) throws DataSetServiceException {
        DataSetEntity dataSetEntity = new DataSetEntity();
        dataSetEntity.setName(name);
        dataSetEntity.setId(id);
        Optional<DataSetListEntity> dataSetListEntity = this.dataSetListRepository.findById(dataSetListId);
        if (!dataSetListEntity.isPresent()) {
            throw new DataSetServiceException("Data Set with id " + dataSetListEntity + " not found");
        }
        dataSetEntity.setDataSetList(dataSetListEntity.get());
        dataSetEntity.setOrdering(ordering);
        dataSetEntity.setSourceId(sourceId);
        dataSetEntity.setLocked(isLocked);
        DataSet dataSet = this.getDataSet(dataSetEntity);
        dataSet.replicate();
        return dataSet;
    }

    public Attribute replicateAttribute(UUID id, String name, AttributeTypeName type, UUID dataSetListId, UUID sourceId) throws DataSetServiceException {
        AttributeEntity attributeEntity = new AttributeEntity();
        attributeEntity.setName(name);
        attributeEntity.setId(id);
        Optional<DataSetListEntity> dataSetListEntity = this.dataSetListRepository.findById(dataSetListId);
        if (!dataSetListEntity.isPresent()) {
            throw new DataSetServiceException("Data Set with id " + dataSetListEntity + " not found");
        }
        attributeEntity.setDataSetList(dataSetListEntity.get());
        attributeEntity.setOrdering(this.getDataSetList(dataSetListEntity.get()).getLastAttributeOrderNumber() + 1);
        attributeEntity.setAttributeTypeId(type.getId());
        attributeEntity.setSourceId(sourceId);
        Attribute attribute = this.getAttribute(attributeEntity);
        attribute.replicate();
        return attribute;
    }

    public Parameter replicateParameter(UUID id, UUID dataSetId, UUID attributeId, UUID sourceId) throws DataSetServiceException {
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setId(id);
        parameterEntity.setSourceId(sourceId);
        Optional<DataSetEntity> dataSetEntity = this.dataSetRepository.findById(dataSetId);
        if (!dataSetEntity.isPresent()) {
            throw new DataSetServiceException("Data Set with id " + dataSetEntity + " not found");
        }
        parameterEntity.setDataSet(dataSetEntity.get());
        AbstractAttributeEntity attributeEntity = (AbstractAttributeEntity)this.attributeRepository.getById(attributeId);
        if (attributeEntity == null) {
            attributeEntity = (AbstractAttributeEntity)this.attributeKeyRepository.getById(attributeId);
        }
        if (attributeEntity == null) {
            throw new DataSetServiceException("Attribute with id " + attributeId + " not found");
        }
        parameterEntity.setAttribute(attributeEntity);
        Parameter parameter = this.getParameter(parameterEntity);
        parameter.replicate();
        return parameter;
    }

    public ListValue replicateListValue(UUID id, String text, UUID attributeId, UUID sourceId) throws DataSetServiceException {
        ListValueEntity listValueEntity = new ListValueEntity();
        listValueEntity.setId(id);
        listValueEntity.setText(text);
        listValueEntity.setSourceId(sourceId);
        Attribute attribute = this.getAttributeById(attributeId);
        if (attribute == null) {
            throw new DataSetServiceException("Attribute with id " + attributeId + " not found");
        }
        listValueEntity.setAttribute((AttributeEntity)attribute.getEntity());
        ListValue listValue = this.getListValue(listValueEntity);
        listValue.replicate();
        return listValue;
    }

    public AttributeKey replicateAttributeKey(UUID id, String key, UUID attributeId, UUID dataSetId, UUID dataSetListId, UUID sourceId) throws DataSetServiceException {
        AttributeKeyEntity attributeKeyEntity = new AttributeKeyEntity();
        attributeKeyEntity.setId(id);
        attributeKeyEntity.setKey(key);
        attributeKeyEntity.setSourceId(sourceId);
        Attribute attribute = this.getAttributeById(attributeId);
        if (attribute == null) {
            throw new DataSetServiceException("Attribute with id " + attributeId + " not found");
        }
        attributeKeyEntity.setAttribute((AttributeEntity)attribute.getEntity());
        DataSet dataSet = this.getDataSetById(dataSetId);
        if (dataSet == null) {
            throw new DataSetServiceException("Data set with id " + dataSetId + " not found");
        }
        attributeKeyEntity.setDataSet((DataSetEntity)dataSet.getEntity());
        DataSetList dataSetList = this.getDataSetListById(dataSetListId);
        if (dataSetList == null) {
            throw new DataSetServiceException("Data set list with id " + dataSetListId + " not found");
        }
        attributeKeyEntity.setDataSetList((DataSetListEntity)dataSetList.getEntity());
        AttributeKey attributeKey = this.getAttributeKey(attributeKeyEntity);
        attributeKey.replicate();
        return attributeKey;
    }

    public List<Attribute> getAttributeByNameAndDataSetListId(String name, UUID dataSetListId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getByNameAndDataSetListId(name, dataSetListId);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<Attribute> getAttributeByDataSetListId(UUID dataSetListId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getByDataSetListId(dataSetListId);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<Attribute> getAttributeBySourceAndDataSetListId(UUID sourceId, UUID dataSetListId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getBySourceIdAndDataSetListId(sourceId, dataSetListId);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<AttributeKey> getAttributeKeyBySourceAndDataSetListId(UUID sourceId, UUID dataSetListId) {
        List<AttributeKeyEntity> attributeEntities = this.attributeKeyRepository.getBySourceIdAndDataSetListId(sourceId, dataSetListId);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getAttributeKey).collect(Collectors.toList());
    }

    public AttributeKey getAttributeKeyByKeyAndDataSetListIdAndDataSetIdAndAttributeId(String key, UUID dataSetListId, UUID datasetId, UUID attributeId) {
        AttributeKeyEntity attributeKeyEntity = this.attributeKeyRepository.findFirstByKeyAndDataSetListIdAndDataSetIdAndAttributeId(key, dataSetListId, datasetId, attributeId);
        return this.getAttributeKey(attributeKeyEntity);
    }

    public List<DataSetList> getDataSetListByNameAndVisibilityAreaId(String name, UUID visibilityArea) {
        List<DataSetListEntity> attributeEntities = this.dataSetListRepository.getByNameAndVisibilityAreaId(name, visibilityArea);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getDataSetList).collect(Collectors.toList());
    }

    public List<DataSetList> getDataSetListByVisibilityAreaId(UUID visibilityArea) {
        List<DataSetListEntity> entities = this.dataSetListRepository.findByVisibilityAreaId(visibilityArea);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        return entities.stream().map(this::getDataSetList).collect(Collectors.toList());
    }

    public PaginationResponse<TableResponse> getAttributesByTypeDatasetListId(UUID dataSetListId, Pageable pageable) {
        Page<AttributeEntity> page = this.attributeRepository.getByTypeDataSetListId(dataSetListId, pageable);
        return this.toPaginationResponse(page, TableResponse::fromAttributeEntity);
    }

    public PaginationResponse<TableResponse> getParametersByDatasetId(UUID dataSetId, Pageable pageable) {
        Page<ParameterEntity> page = this.parameterRepository.getByDataSetReferenceId(dataSetId, pageable);
        return this.toPaginationResponse(page, TableResponse::fromParameterEntity);
    }

    private <T> PaginationResponse<TableResponse> toPaginationResponse(Page<T> page, Function<T, TableResponse> mapFunc) {
        PaginationResponse<TableResponse> response = new PaginationResponse<TableResponse>();
        response.setEntities(page.get().map(mapFunc).collect(Collectors.toList()));
        response.setTotalCount(page.getTotalElements());
        return response;
    }

    public List<DataSetList> getDataSetListBySourceIdAndVisibilityAreaId(UUID sourceId, UUID visibilityArea) {
        List<DataSetListEntity> attributeEntities = this.dataSetListRepository.getBySourceIdAndVisibilityAreaId(sourceId, visibilityArea);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getDataSetList).collect(Collectors.toList());
    }

    public Set<UUID> getDataSetListIdsBySagaSessionIdIdAndVisibilityAreaId(UUID sagaSessionId, UUID visibilityAreaId) {
        return this.dataSetListRepository.findAllIdsBySagaSessionIdAndVisibilityAreaId(sagaSessionId, visibilityAreaId);
    }

    public List<Parameter> getParameterBySourceIdAndDataSetId(UUID sourceId, UUID datasetId) {
        List<ParameterEntity> attributeEntities = this.parameterRepository.getBySourceIdAndDataSetId(sourceId, datasetId);
        if (CollectionUtils.isEmpty(attributeEntities)) {
            return Collections.emptyList();
        }
        return attributeEntities.stream().map(this::getParameter).collect(Collectors.toList());
    }

    public List<Parameter> getSortedParameterByDataSetId(UUID datasetId) {
        List<ParameterEntity> attributeEntities = this.parameterRepository.getByDataSetIdSorted(datasetId);
        return attributeEntities.stream().map(this::getParameter).collect(Collectors.toList());
    }

    public List<Parameter> getSortedOverlapParametersByDataSetId(UUID datasetId) {
        List<ParameterEntity> overlaps = this.parameterRepository.getOverlapByDataSetIdSorted(datasetId);
        return overlaps.stream().map(this::getParameter).collect(Collectors.toList());
    }

    public List<ListValue> getListValueBySourceIdAndAttrId(UUID sourceId, UUID attributeId) {
        List<ListValueEntity> lvEntities = this.listValueRepository.getByAttributeIdAndSourceId(attributeId, sourceId);
        if (CollectionUtils.isEmpty(lvEntities)) {
            return Collections.emptyList();
        }
        return lvEntities.stream().map(this::getListValue).collect(Collectors.toList());
    }

    public ListValue getByAttributeIdAndText(UUID attributeId, String value) {
        return this.getListValue(this.listValueRepository.getByAttributeIdAndText(attributeId, value));
    }

    public List<ListValue> getListValuesByAttributeId(UUID attributeId) {
        List<ListValueEntity> listValueEntities = this.listValueRepository.getByAttributeId(attributeId);
        return listValueEntities.stream().map(this::getListValue).collect(Collectors.toList());
    }

    public List<DataSetList> getByVisibilityAreaId(UUID visibilityAreaId) {
        List<DataSetListEntity> visibilityAreas = this.dataSetListRepository.findAllByVisibilityAreaId(visibilityAreaId);
        return visibilityAreas.stream().map(this::getDataSetList).collect(Collectors.toList());
    }

    public List<DataSet> getByDataSetListIdIn(Collection<UUID> dataSetListIds) {
        List<DataSetEntity> datasets = this.dataSetRepository.findByDataSetListIdIn(dataSetListIds);
        return datasets.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<DataSet> getByIds(Collection<UUID> ids) {
        List datasets = this.dataSetRepository.findAllById(ids);
        return datasets.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<UUID> getParametersIdByDsId(UUID dsId) {
        return this.parameterRepository.getParametersIdByDataSetReferenceId(dsId);
    }

    public List<DataSet> getLockedDatasets(UUID dataSetListId) {
        List<DataSetEntity> dataSets = this.dataSetRepository.findByDataSetListIdAndLocked(dataSetListId, true);
        return dataSets.stream().map(this::getDataSet).collect(Collectors.toList());
    }

    public List<String> getNotUniqueDslNames(UUID visibilityArea) {
        return this.dataSetListRepository.getNotUniqueDslNames(visibilityArea);
    }

    public List<String> getDsNamesForDsl(UUID datasetListId) {
        return this.dataSetRepository.getDsNames(datasetListId);
    }

    public UUID getDatasetListIdByDatasetId(UUID dsId) {
        return this.dataSetRepository.getDslId(dsId).orElseThrow(DataSetNotFoundException::new);
    }

    public UUID getDataSetsListIdByDataSetId(UUID dsId) {
        return this.dataSetRepository.getDataSetsListIdByDataSetId(dsId);
    }

    public LinkedList<UUID> getDataSetsIdsByDataSetListId(UUID dataSetListId) {
        return this.dataSetListRepository.getDataSetsIdsByDataSetListId(dataSetListId);
    }

    public LinkedList<UUID> getAffectedDataSetsListIdsByDataSetListId(List<UUID> dataSetListId) {
        return this.dataSetListRepository.getAffectedDataSetListIdsByDataSetListId(dataSetListId);
    }

    public Set<UUID> getAffectedDataSetsIdsByDataSetListId(Set<UUID> dataSetListId) {
        return this.dataSetListRepository.getAffectedDataSetIdsByDataSetListId(dataSetListId);
    }

    public int countAttributes(UUID datasetId) {
        return this.attributeRepository.countAttributesByDataset(datasetId);
    }

    public List<Attribute> getNotUsedAttributesByDatasetId(UUID datasetId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getNotUsedByDatasetId(datasetId);
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public AttributeTypeName getAttributeTypeByAttributeId(UUID attributeId) {
        return this.attributeTypeRepository.findByAttributeId(attributeId).getEnum();
    }

    public List<Attribute> getAttributesByDataSetId(UUID dataSetId) {
        List<AttributeEntity> attributeEntities = this.attributeRepository.getByDatasetId(dataSetId);
        return attributeEntities.stream().map(this::getAttribute).collect(Collectors.toList());
    }

    public List<AttributeKey> getAttributesKeyByDataSetId(UUID dataSetId) {
        List<AttributeKeyEntity> attributeKeyEntities = this.attributeKeyRepository.findByDataSetId(dataSetId);
        return attributeKeyEntities.stream().map(this::getAttributeKey).collect(Collectors.toList());
    }

    public boolean isDsLocked(UUID dataSetId) {
        return this.dataSetRepository.isLocked(dataSetId);
    }

    public boolean isDslDifferentAttributes(UUID leftAttrId, UUID rightAttrId) {
        return this.attributeRepository.isDifferentDslAttributes(leftAttrId, rightAttrId);
    }

    public Set<UUID> getUniqueDataSetIdsByReferenceDataSetId(UUID dataSetId) {
        return this.parameterRepository.getUniqueDataSetIdsByDataSetReferenceId(dataSetId);
    }
}

