/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import java.util.stream.Stream;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DumbArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.service.direct.impl.AtpMacrosCacheServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AtpContextMacros
extends Macros<String> {
    @Autowired
    private AtpMacrosCacheServiceImpl macrosCacheService;

    public AtpContextMacros() {
        super("CONTEXT");
    }

    @Override
    public String evaluate(Stream<? extends MacroArg> input, EvaluationContext context) throws Exception {
        String text = input.findAny().orElseThrow(() -> new IllegalArgumentException("One argument expected")).getText();
        String result = this.macrosCacheService.getValue(text);
        return result == null ? text + " not found" : result;
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DumbArgsParser();
    }

    @Override
    public boolean doCache() {
        return true;
    }
}

