/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public enum AttributeType {
    TEXT(1),
    FILE(2),
    LIST(3),
    DSL(4),
    CHANGE(5),
    ENCRYPTED(6);

    private static final Map<Short, AttributeType> shortMapping;
    private final short id;

    private AttributeType(short id) {
        this.id = id;
    }

    @Nonnull
    public static AttributeType from(short id) {
        return shortMapping.computeIfAbsent(id, someId -> Arrays.stream(AttributeType.values()).filter(type -> someId.equals(type.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Illegal attribute type specified. Expected: " + Arrays.toString((Object[])AttributeType.values()))));
    }

    public short getId() {
        return this.id;
    }

    public String getName() {
        return this.name();
    }

    static {
        shortMapping = new HashMap<Short, AttributeType>();
    }
}

