/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.utils.ChangeType;

public class Change {
    private static final Splitter SPLITTER = Splitter.on((char)' ');
    public final ChangeType type;
    public final List<UUID> arguments;

    public Change(ChangeType type, List<UUID> arguments) {
        this.type = type;
        this.arguments = arguments;
    }

    @Nonnull
    public static Change fromText(@Nonnull String text) {
        Iterator iterator = SPLITTER.split((CharSequence)text).iterator();
        Preconditions.checkArgument((boolean)iterator.hasNext(), (Object)"Macro is empty and can not be parsed");
        String next = (String)iterator.next();
        ChangeType change = ChangeType.valueOf(next);
        ArrayList args = Lists.newArrayList((Iterator)Iterators.transform(iterator, UUID::fromString));
        return new Change(change, args);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("arguments", this.arguments).toString();
    }
}

