/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import org.qubership.atp.dataset.model.Identified;

public class FlatSerializerModifier
extends BeanSerializerModifier {
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (Identified.class.isAssignableFrom(beanDesc.getBeanClass())) {
            return new FlatSerializer((BeanSerializerBase)serializer);
        }
        return serializer;
    }

    private static class FlatSerializer
    extends BeanSerializerBase {
        BeanSerializerBase defaultSerializer;

        public FlatSerializer(BeanSerializerBase src) {
            super(src);
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, Set<String> toIgnore) {
            super(src, toIgnore);
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
            super(src, toIgnore, toInclude);
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, ObjectIdWriter oiw) {
            super(src, oiw);
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId) {
            super(src, oiw, filterId);
            this.defaultSerializer = src;
        }

        protected FlatSerializer(BeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
            super(src, properties, filteredProperties);
            this.defaultSerializer = src;
        }

        public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
            return new FlatSerializer(this.defaultSerializer, objectIdWriter);
        }

        protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
            return new FlatSerializer(this.defaultSerializer, toIgnore);
        }

        protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
            return new FlatSerializer((BeanSerializerBase)this, toIgnore, toInclude);
        }

        protected BeanSerializerBase asArraySerializer() {
            if (this._objectIdWriter == null && this._anyGetterWriter == null && this._propertyFilterId == null) {
                return new BeanAsArraySerializer((BeanSerializerBase)this);
            }
            return this;
        }

        public BeanSerializerBase withFilterId(Object filterId) {
            return new FlatSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
        }

        protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
            return new FlatSerializer((BeanSerializerBase)this, properties, filteredProperties);
        }

        public void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (this._objectIdWriter != null) {
                gen.setCurrentValue(bean);
                this.flatSerializeWithObjectId(bean, gen, provider, true, () -> this.asId(gen));
                return;
            }
            gen.writeStartObject(bean);
            if (this._propertyFilterId != null) {
                this.serializeFieldsFiltered(bean, gen, provider);
            } else {
                this.serializeFields(bean, gen, provider);
            }
            gen.writeEndObject();
        }

        protected void flatSerializeWithObjectId(Object bean, JsonGenerator gen, SerializerProvider provider, boolean startEndObject, Supplier<Boolean> asId) throws IOException {
            ObjectIdWriter w = this._objectIdWriter;
            WritableObjectId objectId = provider.findObjectId(bean, w.generator);
            if (objectId.writeAsId(gen, provider, w)) {
                return;
            }
            Object id = objectId.generateId(bean);
            if (w.alwaysAsId || asId.get().booleanValue()) {
                w.serializer.serialize(id, gen, provider);
                return;
            }
            if (startEndObject) {
                gen.writeStartObject(bean);
            }
            objectId.writeAsField(gen, provider, w);
            if (this._propertyFilterId != null) {
                this.serializeFieldsFiltered(bean, gen, provider);
            } else {
                this.serializeFields(bean, gen, provider);
            }
            if (startEndObject) {
                gen.writeEndObject();
            }
        }

        private boolean asId(JsonGenerator gen) {
            JsonStreamContext current = gen.getOutputContext();
            while (!current.inRoot()) {
                Object objToCheck = (current = current.getParent()).getCurrentValue();
                if (objToCheck == null || !Identified.class.isAssignableFrom(objToCheck.getClass())) continue;
                return true;
            }
            return false;
        }
    }
}

