/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.service.direct.importexport.exceptions.ImportFailedException;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AttributeImportModel {
    private static final Logger log = LoggerFactory.getLogger(AttributeImportModel.class);
    private UUID id;
    private String name;
    private String key;
    private AttributeType type;
    private String rootDatasetListName;
    private String datasetListReference;
    private List<UUID> path = new ArrayList<UUID>();
    private List<DatasetParameterValue> datasetParameterValues = new ArrayList<DatasetParameterValue>();
    private AttributeImportModel parent;
    private List<AttributeImportModel> children = new ArrayList<AttributeImportModel>();

    public AttributeImportModel(UUID id, String name, String key, AttributeType type) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.type = type;
    }

    public DatasetParameterValue getDatasetParameterValue(String datasetName) {
        return this.datasetParameterValues.stream().filter(datasetParameterValue -> datasetParameterValue.getDatasetName().equals(datasetName)).findAny().orElseThrow(() -> {
            String errorMessage = "Failed to find dataset parameter value by dataset name: " + datasetName;
            log.debug(errorMessage);
            return new ImportFailedException(errorMessage);
        });
    }

    public String getDatasetParameterValuesDslReference() {
        return this.datasetParameterValues.stream().map(DatasetParameterValue::getDatasetListReference).findAny().orElse("");
    }

    public void addPath(AttributeImportModel parentModel) {
        List<UUID> parentAttributePath = parentModel.getPath();
        if (!CollectionUtils.isEmpty(parentAttributePath)) {
            this.path.addAll(parentAttributePath);
        }
        this.path.add(parentModel.getId());
    }

    public void addChildren(AttributeImportModel child) {
        this.children.add(child);
    }

    public void fillParentDslReferences(AttributeImportModel parentModel) {
        Map<String, DatasetParameterValue> parentDatasetParametersMap = StreamUtils.toEntityMap(parentModel.getDatasetParameterValues(), DatasetParameterValue::getDatasetName);
        this.datasetParameterValues.forEach(childParentDatasetParameterValue -> {
            DatasetParameterValue parentDatasetParameterValue = (DatasetParameterValue)parentDatasetParametersMap.get(childParentDatasetParameterValue.getDatasetName());
            String parentDatasetListReference = parentDatasetParameterValue.getDatasetListReference();
            childParentDatasetParameterValue.setDatasetListReference(parentDatasetListReference);
            String parentDatasetReference = parentDatasetParameterValue.getDatasetReference();
            childParentDatasetParameterValue.setDatasetReference(parentDatasetReference);
        });
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public AttributeType getType() {
        return this.type;
    }

    public String getRootDatasetListName() {
        return this.rootDatasetListName;
    }

    public String getDatasetListReference() {
        return this.datasetListReference;
    }

    public List<UUID> getPath() {
        return this.path;
    }

    public List<DatasetParameterValue> getDatasetParameterValues() {
        return this.datasetParameterValues;
    }

    public AttributeImportModel getParent() {
        return this.parent;
    }

    public List<AttributeImportModel> getChildren() {
        return this.children;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public void setRootDatasetListName(String rootDatasetListName) {
        this.rootDatasetListName = rootDatasetListName;
    }

    public void setDatasetListReference(String datasetListReference) {
        this.datasetListReference = datasetListReference;
    }

    public void setPath(List<UUID> path) {
        this.path = path;
    }

    public void setDatasetParameterValues(List<DatasetParameterValue> datasetParameterValues) {
        this.datasetParameterValues = datasetParameterValues;
    }

    public void setParent(AttributeImportModel parent) {
        this.parent = parent;
    }

    public void setChildren(List<AttributeImportModel> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeImportModel)) {
            return false;
        }
        AttributeImportModel other = (AttributeImportModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$rootDatasetListName = this.getRootDatasetListName();
        String other$rootDatasetListName = other.getRootDatasetListName();
        if (this$rootDatasetListName == null ? other$rootDatasetListName != null : !this$rootDatasetListName.equals(other$rootDatasetListName)) {
            return false;
        }
        String this$datasetListReference = this.getDatasetListReference();
        String other$datasetListReference = other.getDatasetListReference();
        if (this$datasetListReference == null ? other$datasetListReference != null : !this$datasetListReference.equals(other$datasetListReference)) {
            return false;
        }
        List<UUID> this$path = this.getPath();
        List<UUID> other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        List<DatasetParameterValue> this$datasetParameterValues = this.getDatasetParameterValues();
        List<DatasetParameterValue> other$datasetParameterValues = other.getDatasetParameterValues();
        if (this$datasetParameterValues == null ? other$datasetParameterValues != null : !((Object)this$datasetParameterValues).equals(other$datasetParameterValues)) {
            return false;
        }
        AttributeImportModel this$parent = this.getParent();
        AttributeImportModel other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<AttributeImportModel> this$children = this.getChildren();
        List<AttributeImportModel> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeImportModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $rootDatasetListName = this.getRootDatasetListName();
        result = result * 59 + ($rootDatasetListName == null ? 43 : $rootDatasetListName.hashCode());
        String $datasetListReference = this.getDatasetListReference();
        result = result * 59 + ($datasetListReference == null ? 43 : $datasetListReference.hashCode());
        List<UUID> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        List<DatasetParameterValue> $datasetParameterValues = this.getDatasetParameterValues();
        result = result * 59 + ($datasetParameterValues == null ? 43 : ((Object)$datasetParameterValues).hashCode());
        AttributeImportModel $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<AttributeImportModel> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeImportModel(id=" + this.getId() + ", name=" + this.getName() + ", key=" + this.getKey() + ", type=" + (Object)((Object)this.getType()) + ", rootDatasetListName=" + this.getRootDatasetListName() + ", datasetListReference=" + this.getDatasetListReference() + ", path=" + this.getPath() + ", datasetParameterValues=" + this.getDatasetParameterValues() + ", children=" + this.getChildren() + ")";
    }

    public AttributeImportModel(UUID id, String name, String key, AttributeType type, String rootDatasetListName, String datasetListReference, List<UUID> path, List<DatasetParameterValue> datasetParameterValues, AttributeImportModel parent, List<AttributeImportModel> children) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.type = type;
        this.rootDatasetListName = rootDatasetListName;
        this.datasetListReference = datasetListReference;
        this.path = path;
        this.datasetParameterValues = datasetParameterValues;
        this.parent = parent;
        this.children = children;
    }

    public AttributeImportModel() {
    }
}

