/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dscontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.CycleChecker;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class GroupContext
implements Serializable {
    private static final long serialVersionUID = -7833021868343081645L;
    private long order;
    private String name;
    private UUID id;
    private UUID dataSetListId;
    private String dataSetListName;
    private List<UUID> currentPath;
    private List<DataSetContext> dataSets = new LinkedList<DataSetContext>();
    private List<GroupContext> groups = new LinkedList<GroupContext>();
    private List<Attribute> attributes;
    @JsonIgnore
    private boolean isLastPage = false;

    public GroupContext(List<DataSetContext> previousLevelDataSets, Attribute parentDataSetListReferenceAttribute, OverlapNode overlaps, List<UUID> parentPath, List<AttributeTypeName> attributeTypeNames, CycleChecker cycleChecker, List<UUID> pathRestrictions, UUID dataSetListId, Pageable pageable) {
        List<Attribute> attributeList;
        this.currentPath = new LinkedList<UUID>(parentPath);
        this.currentPath.add(parentDataSetListReferenceAttribute.getId());
        this.name = parentDataSetListReferenceAttribute.getName();
        this.order = parentDataSetListReferenceAttribute.getOrdering().intValue();
        this.id = parentDataSetListReferenceAttribute.getId();
        DataSetList referencedDataSetList = parentDataSetListReferenceAttribute.getTypeDataSetList();
        if (pageable != null) {
            Page<AttributeEntity> attributesByTypesPageable = referencedDataSetList.getAttributesByTypesPageable(dataSetListId, attributeTypeNames, pageable);
            attributeList = referencedDataSetList.getAttributesOfPage(attributesByTypesPageable, attributeTypeNames);
            this.isLastPage = attributesByTypesPageable.isLast();
        } else {
            attributeList = referencedDataSetList.getAttributesByTypes(attributeTypeNames);
        }
        this.attributes = attributeList;
        this.dataSetListId = dataSetListId;
        this.dataSetListName = referencedDataSetList.getName();
        List<Parameter> dataSetReferences = parentDataSetListReferenceAttribute.getParameters();
        for (DataSetContext previousLevelDataSet : previousLevelDataSets) {
            AttributeKey overlap;
            if (previousLevelDataSet.getName() == null) {
                this.dataSets.add(new DataSetContext(previousLevelDataSet.getColumnNumber(), attributeList, overlaps, this.currentPath, pathRestrictions));
                continue;
            }
            boolean referenceFound = false;
            Parameter foundDataSetReference = null;
            for (Parameter dataSetReference : dataSetReferences) {
                if (!dataSetReference.getDataSet().getId().equals(previousLevelDataSet.getId())) continue;
                AttributeKey overlap2 = overlaps.getOverlap(parentPath, previousLevelDataSet.getColumnNumber(), parentDataSetListReferenceAttribute.getId());
                foundDataSetReference = overlap2 != null ? overlap2.getParameter() : dataSetReference;
                referenceFound = true;
                break;
            }
            if (!referenceFound && (overlap = overlaps.getOverlap(parentPath, previousLevelDataSet.getColumnNumber(), parentDataSetListReferenceAttribute.getId())) != null) {
                foundDataSetReference = overlap.getParameter();
            }
            if (foundDataSetReference != null && foundDataSetReference.getDataSetReferenceValue() != null) {
                DataSet referencedDataSet = foundDataSetReference.getDataSetReferenceValue();
                this.dataSets.add(new DataSetContext(previousLevelDataSet.getColumnNumber(), referencedDataSet, attributeList, overlaps, this.currentPath, pathRestrictions));
                continue;
            }
            this.dataSets.add(new DataSetContext(previousLevelDataSet.getColumnNumber(), attributeList, overlaps, this.currentPath, pathRestrictions));
        }
        List<Attribute> dataSetListReferenceAttribute = referencedDataSetList.getDataSetListReferences();
        for (Attribute dataSetListAttribute : dataSetListReferenceAttribute) {
            UUID referencedDataSetListId;
            DataSetList dataSetList = dataSetListAttribute.getDataSetList();
            for (DataSetContext currentLevelDataSet : this.dataSets) {
                if (currentLevelDataSet.getId() == null) continue;
                List<AttributeKey> attributeKeys = dataSetList.getAttributeKeysByDataSet(currentLevelDataSet.getId());
                for (AttributeKey attributeKey : attributeKeys) {
                    LinkedList<UUID> overlapPath = new LinkedList<UUID>(this.currentPath);
                    overlapPath.addAll(attributeKey.getPath());
                    overlaps.addOverlap(overlapPath, currentLevelDataSet.getColumnNumber(), attributeKey);
                }
            }
            if (pathRestrictions == null) {
                referencedDataSetListId = dataSetListAttribute.getTypeDataSetList().getId();
                cycleChecker.openNode(referencedDataSetListId);
                this.groups.add(new GroupContext(this.dataSets, dataSetListAttribute, overlaps, this.currentPath, attributeTypeNames, cycleChecker, null, referencedDataSetListId, pageable));
                cycleChecker.closeNode(referencedDataSetListId);
                continue;
            }
            if (pathRestrictions.isEmpty() || !pathRestrictions.get(0).equals(dataSetListAttribute.getId())) continue;
            referencedDataSetListId = dataSetListAttribute.getTypeDataSetList().getId();
            cycleChecker.openNode(referencedDataSetListId);
            this.groups.add(new GroupContext(this.dataSets, dataSetListAttribute, overlaps, this.currentPath, attributeTypeNames, cycleChecker, pathRestrictions.subList(1, pathRestrictions.size()), referencedDataSetListId, pageable));
            cycleChecker.closeNode(referencedDataSetListId);
            break;
        }
    }

    public long getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getDataSetListId() {
        return this.dataSetListId;
    }

    public String getDataSetListName() {
        return this.dataSetListName;
    }

    public List<UUID> getCurrentPath() {
        return this.currentPath;
    }

    public List<DataSetContext> getDataSets() {
        return this.dataSets;
    }

    public List<GroupContext> getGroups() {
        return this.groups;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setDataSetListId(UUID dataSetListId) {
        this.dataSetListId = dataSetListId;
    }

    public void setDataSetListName(String dataSetListName) {
        this.dataSetListName = dataSetListName;
    }

    public void setCurrentPath(List<UUID> currentPath) {
        this.currentPath = currentPath;
    }

    public void setDataSets(List<DataSetContext> dataSets) {
        this.dataSets = dataSets;
    }

    public void setGroups(List<GroupContext> groups) {
        this.groups = groups;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @JsonIgnore
    public void setLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }
}

