/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mysema.commons.lang.Pair;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.qubership.atp.dataset.exception.dataset.DataSetContextParseException;
import org.qubership.atp.dataset.exception.dataset.DataSetIdNotSpecifiedException;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.api.CompareDsRequest;
import org.qubership.atp.dataset.model.api.CompareDsResponse;
import org.qubership.atp.dataset.model.api.CopyDsAttributeBulkRequest;
import org.qubership.atp.dataset.model.api.CopyDsAttributeRequest;
import org.qubership.atp.dataset.model.api.CopyDsAttributeResponse;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsRequest;
import org.qubership.atp.dataset.model.api.DetailedComparisonDsResponse;
import org.qubership.atp.dataset.model.enums.CompareStatus;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.CheckedConsumer;
import org.qubership.atp.dataset.model.utils.ObjectShortResponse;
import org.qubership.atp.dataset.service.direct.CompareService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetTree;
import org.qubership.atp.dataset.service.rest.PaginationResponse;
import org.qubership.atp.dataset.service.rest.QueryParamFlag;
import org.qubership.atp.dataset.service.rest.dto.manager.AbstractEntityResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/ds"})
public class DataSetController {
    private static final Logger log = LoggerFactory.getLogger(DataSetController.class);
    private final DataSetService dsService;
    private final ObjectMapper jsonObjectMapper;
    private final ConcurrentModificationService concurrentModificationService;
    private final JpaDataSetService dataSetService;
    private final CompareService compare;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(), 'CREATE')")
    @PutMapping(value={"/{dataSetListId}/ds"})
    @AuditAction(auditAction="Creates new dataset with name: {{#name}} in dataset list: {{#dataSetListId}}")
    @Operation(summary="Creates new DS with name provided.")
    public ResponseEntity<UUID> create(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="name") String name, HttpServletRequest request, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        UUID dsId = this.dataSetService.create(name, dataSetListId).getId();
        String url = request.getRequestURL().append("/").append(dsId.toString()).toString();
        URI uri = URI.create(url);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)httpStatus).location(uri)).body((Object)dsId) : ResponseEntity.created((URI)uri).body((Object)dsId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'DELETE')")
    @DeleteMapping(value={"/{dataSetId}"})
    @AuditAction(auditAction="Delete dataset: {{#dataSetId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Deletes selected DS.")
    public ResponseEntity<Void> delete(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.dsService.delete(dataSetId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping
    @AuditAction(auditAction="Get all dataSets")
    @Operation(summary="Returns all dataSets.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    public List<DataSet> getDataSets() {
        return this.dsService.getAll();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),#visibilityAreaId, 'READ')")
    @GetMapping(value={"/find-name-pagination"})
    @AuditAction(auditAction="Get dataset: {{#name}} in project: {{#visibilityAreaId}}")
    @Operation(summary="Returns all dataSets.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    public Page<AbstractEntityResponse> getDataSetsByName(@RequestParam(value="name") String name, @RequestParam(value="projectId") UUID visibilityAreaId, @ParameterObject @PageableDefault(sort={"name"}, direction=Sort.Direction.ASC) Pageable pageable) {
        return this.dataSetService.getDatasetsIdNamesPageByNameAndVaId(name, visibilityAreaId, pageable);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetId}"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}}")
    @Operation(summary="Returns dataSet by id.")
    public Object getDataSetById(@PathVariable(value="dataSetId") UUID dataSetId) {
        return this.dsService.get(dataSetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId.getUuid()).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @GetMapping(value={"/{dataSetId}/legacy/itf"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ITF format")
    @Operation(summary="Returns dataSet by id in ITF format: {attribute = parameter, attribute2 : {attribute = parameter2}}.")
    public Object getInItfFormat(@PathVariable(value="dataSetId") MixInId dataSetId) {
        return this.dsService.getInItfFormat(dataSetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId.getUuid()).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/legacy/atp"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ITF format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public ResponseEntity<StreamingResponseBody> getDataSetsForAtp(@PathVariable(value="dataSetId") MixInId dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody(required=false) String atpContext) {
        CheckedConsumer<OutputStream, IOException> streamConsumer;
        Map context = null;
        if (!Strings.isNullOrEmpty((String)atpContext)) {
            try {
                context = (Map)this.jsonObjectMapper.readValue(atpContext, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (Exception e) {
                log.error("Cannot parse ATP Context for DataSet id='" + dataSetId.getUuid() + "'");
                throw new DataSetContextParseException();
            }
        }
        if ((streamConsumer = this.dsService.writeInAtpFormat(dataSetId, context, QueryParamFlag.isPresent(evaluate))) == null) {
            return ResponseEntity.noContent().build();
        }
        StreamingResponseBody stream = streamConsumer::accept;
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_STREAM_JSON).body((Object)stream);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public DataSetTree getAtpContextFull(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, isEvaluate, atpContext, ContextType.FULL);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/bulk"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public List<JSONObject> getAtpContextFull(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestParam(value="countOfEvaluates", required=false, defaultValue="1") Integer countOfEvaluates, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, isEvaluate, atpContext, ContextType.FULL, countOfEvaluates);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/object"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public DataSetTree getAtpContextObject(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, QueryParamFlag.isPresent(evaluate), atpContext, ContextType.OBJECT);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/object/bulk"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public List<JSONObject> getAtpContextObject(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestParam(value="countOfEvaluates", required=false, defaultValue="1") Integer countOfEvaluates, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, QueryParamFlag.isPresent(evaluate), atpContext, ContextType.OBJECT, countOfEvaluates);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/optimized"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public DataSetTree getAtpContextOptimized(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format optimized '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, QueryParamFlag.isPresent(evaluate), atpContext, ContextType.NO_NULL_VALUES);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/optimized/bulk"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    public List<JSONObject> getAtpContextOptimized(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestParam(value="countOfEvaluates", required=false, defaultValue="1") Integer countOfEvaluates, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format optimized '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, QueryParamFlag.isPresent(evaluate), atpContext, ContextType.NO_NULL_VALUES, countOfEvaluates);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @PostMapping(value={"/{dataSetId}/atp/objectExtended"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ATP format + atp macros")
    @Operation(summary="Returns dataSet by id in ATP format + atp macros")
    public DataSetTree getAtpContextObjectExtended(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody(required=false) String atpContext) {
        boolean isEvaluate = QueryParamFlag.isPresent(evaluate);
        log.info("Request for Data Set in ATP format object extended '{}' with evaluate={}", (Object)dataSetId, (Object)isEvaluate);
        return this.dataSetService.getDataSetTreeInAtpFormat(dataSetId, QueryParamFlag.isPresent(evaluate), atpContext, ContextType.OBJECT_EXTENDED);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(), 'READ')")
    @Operation(summary="Returns dataSet by id in ITF format + atp macros")
    @GetMapping(value={"/{dataSetId}/itf"}, produces={"application/json"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} in ITF format")
    public String getItfContext(@PathVariable(value="dataSetId") UUID dataSetId) {
        return this.dataSetService.getDataSetTreeInItfFormat(dataSetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{dataSetId}"})
    @AuditAction(auditAction="Rename dataset: {{#dataSetId}} on {{#name}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Renames DS.")
    public ResponseEntity<Void> rename(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="name") String name, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.dsService.rename(dataSetId, name);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/{dataSetId}/parameters"})
    @AuditAction(auditAction="Get attribute of dataset: {{#dataSetId}}")
    public UiManAttribute getUiAttribute(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestBody List<UUID> attrPathIds) {
        if (dataSetId != null && attrPathIds != null) {
            return this.dsService.getParametersOnAttributePath(dataSetId, attrPathIds, QueryParamFlag.isPresent(evaluate));
        }
        return null;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/affected/by"})
    @AuditAction(auditAction="Get dataset: {{#dataSetId}} or TableResponse with overridden parameters")
    @Operation(summary="Returns all affected datasets by changes at attribute.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    public List<?> getDatasetsOrTableResponseAffectedByChangeParameterValue(@RequestParam(value="dataSetId") UUID dataSetId, @RequestParam(value="attributeId") UUID attrId, @RequestParam(value="full", required=false) QueryParamFlag full) {
        boolean withInfo = QueryParamFlag.isPresent(full);
        return this.dsService.getOverlapContainers(dataSetId, attrId, withInfo);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetsIds.get(0)).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/reset/affected/by"})
    @AuditAction(auditAction="Reset to default value overridden parameters in dataset list: {{#dataSetListId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Reset all selected datasets, at changed attribute")
    public ResponseEntity<Void> restAffectedDatasetsByChangesAttribute(@RequestParam(value="attributeId", required=false) UUID attributeId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestBody(required=false) List<UUID> dataSetsIds) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.dsService.deleteAllParameterOverlaps(attributeId, dataSetsIds);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'CREATE')")
    @PutMapping(value={"/{dataSetId}/copy"})
    @AuditAction(auditAction="Copy dataset: {{#dataSetId}} with name: {{#name}}")
    @Operation(summary="Copy DS with name provided.")
    public UUID copy(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="name") String name) {
        return this.dsService.copy(dataSetId, name).getId();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dsId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/parent/path"})
    @AuditAction(auditAction="Get path to dataset: {{#dsId}}")
    @Operation(summary="Returns visibility area and data set list ids", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Pair.class))})})
    public Pair<UUID, UUID> getPath(@RequestParam(value="dsId") UUID dsId) {
        DataSet dataSet = (DataSet)this.dsService.get(dsId);
        Preconditions.checkNotNull((Object)dataSet, (Object)("DataSet with ID" + dsId + " not found"));
        return Pair.of((Object)dataSet.getDataSetList().getVisibilityArea().getId(), (Object)dataSet.getDataSetList().getId());
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/dsReferenceId/affected/by"})
    @AuditAction(auditAction="Get all affected dataSets by changes at reference: {{#dsReferenceId}}")
    @Operation(summary="Returns all affected dataSets by changes at reference value.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    public List<?> getAffectedDataSetsByChangesDataSetReference(@RequestParam(value="dsReferenceId") UUID dsReferenceId, @RequestParam(value="full", required=false) QueryParamFlag full) {
        boolean deleteDs = QueryParamFlag.isPresent(full);
        return this.dsService.getAffectedDataSetsByChangesDataSetReference(dsReferenceId, deleteDs);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetId}/affectedDatasets"})
    @AuditAction(auditAction="Get all affected dataSets by changes at reference: {{#dataSetId}} with pagination")
    @Operation(summary="Returns all affected dataSets by specified reference with pagination support.")
    public PaginationResponse<TableResponse> getAffectedDataSets(@PathVariable UUID dataSetId, @RequestParam Integer page, @RequestParam Integer size) {
        return this.dsService.getAffectedDataSets(dataSetId, page, size);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetId}/affectedDatasetsCount"})
    @Operation(summary="Returns all affected dataSets count by specified reference.")
    @AuditAction(auditAction="Get count of affected dataSets by changes at reference: {{#dataSetId}}")
    public Long getAffectedDataSetsCount(@PathVariable UUID dataSetId) {
        return this.dsService.getAffectedDataSetsCount(dataSetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/reset/by"})
    @Operation(summary="Reset all selected datasets, at changed attribute. dataSetIds is ids of datasets in which we want to reset overridden parameters with attributeId provided")
    @AuditAction(auditAction="Reset overridden parameter in dataset: {{#dataSetId}} and attribute: {{#targetAttrId}}")
    public ResponseEntity<Parameter> resetOverriddenParameter(@RequestParam(value="dataSetId") UUID dataSetId, @RequestParam(value="targetAttrId") UUID targetAttrId, @RequestBody List<UUID> attrPathIds, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        Parameter parameter = this.dsService.deleteParameterOverlap(dataSetId, targetAttrId, attrPathIds);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)parameter) : ResponseEntity.ok((Object)parameter);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PutMapping(value={"/{dataSetId}/label"})
    @AuditAction(auditAction="Add label: {{#name}} to dataset: {{#dataSetId}}")
    public ResponseEntity<Label> addLabel(@PathVariable(value="dataSetId") UUID dataSetId, @RequestParam(value="name") String name, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        Label label = this.dsService.mark(dataSetId, name);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)label) : ResponseEntity.ok((Object)label);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetId}/label"})
    @AuditAction(auditAction="Get labels for dataset: {{#dataSetId}}")
    public List<Label> getLabels(@PathVariable(value="dataSetId") UUID dataSetId) {
        return this.dsService.getLabels(dataSetId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @DeleteMapping(value={"/{dataSetId}/label/{labelId}"})
    @AuditAction(auditAction="Delete label: {{#labelId}} for dataset: {{#dataSetId}}")
    public ResponseEntity<Boolean> deleteLabel(@PathVariable(value="dataSetId") UUID dataSetId, @PathVariable(value="labelId") UUID labelId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean isUnmark = this.dsService.unmark(dataSetId, labelId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)isUnmark) : ResponseEntity.ok((Object)isUnmark);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetJson.get(\"id\").asText()).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/restore"})
    @AuditAction(auditAction="Restore dataset in dataset list: {{#dataSetListId}}")
    public ResponseEntity<Boolean> restore(@RequestBody JsonNode dataSetJson, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean isRestored = this.dsService.restore(dataSetJson);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)isRestored) : ResponseEntity.ok((Object)isRestored);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/short"})
    @AuditAction(auditAction="Get datasets short in dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns list of Datasets (id + name) for selected DSL.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ObjectShortResponse.class)))})})
    public List<ObjectShortResponse> getDataSetsShort(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.dsService.getByParentId(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{dataSetId}/position"})
    @AuditAction(auditAction="Set position of dataset: {{#dataSetId}}")
    @Operation(summary="Creates new list values for provided attribute by text.")
    public void setPosition(@PathVariable(value="dataSetId") UUID dataSetId, @RequestBody Integer position) {
        this.dataSetService.setPosition(dataSetId, position);
    }

    @PreAuthorize(value="#isLock ? @entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(), 'LOCK') : @entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(), 'UNLOCK')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PostMapping(value={"/lock/update"})
    @AuditAction(auditAction="Lock datasets: {{#dataSetListId}} in dataset list: {{#dataSetId}}")
    @Operation(summary="Lock")
    public ResponseEntity<Void> lock(@RequestParam(value="dataSetListId") UUID dataSetListId, @RequestParam boolean isLock, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestBody List<UUID> dataSetsIds) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        this.dsService.lock(dataSetListId, dataSetsIds, isLock);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#dataSetsIds.get(0)).getDataSetList().getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/listOfDatasets"})
    @Operation(summary="Returns dataSets by id-s.")
    public List<DataSet> getDataSetsByIds(@RequestBody List<UUID> dataSetsIds) {
        return this.dsService.getAll(dataSetsIds);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/compare"})
    @Operation(summary="Compare Datasets from different test cases")
    public CompareDsResponse compareDsAtp(@RequestBody CompareDsRequest request) {
        UUID leftDataSetId = request.getLeftDataSetId();
        UUID rightDataSetId = request.getRightDataSetId();
        if (Objects.isNull(leftDataSetId) || Objects.isNull(rightDataSetId)) {
            throw new DataSetIdNotSpecifiedException();
        }
        CompareStatus status = this.compare.compare(leftDataSetId, rightDataSetId);
        return new CompareDsResponse(status);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#request.getLeftDatasetId()).getDataSetList().getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/compare/detailed"})
    @Operation(summary="Detailed comparison datasets")
    public DetailedComparisonDsResponse detailedComparisonDsAtp(@RequestBody DetailedComparisonDsRequest request) {
        return this.compare.detailedComparison(request);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#request.getTargetDataSetId()).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/compare/copy"})
    @Operation(summary="Copy attribute from source dataset to target dataset")
    public CopyDsAttributeResponse copyDsAttributes(@RequestBody CopyDsAttributeRequest request) {
        UUID targetAttributeId = this.dataSetService.copyDsAttributeValue(request.getSourceDataSetId(), request.getTargetDataSetId(), request.getSourceAttributeId(), request.getTargetAttributeId());
        return new CopyDsAttributeResponse(targetAttributeId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetServiceImpl.get(#request.getTargetDataSetId()).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/compare/copy/bulk"})
    @Operation(summary="Copy all attributes from source dataset to target dataset")
    public void copyDsAttributesBulk(@RequestBody CopyDsAttributeBulkRequest request) {
        this.dataSetService.copyDsAttributeValueBulk(request.getSourceDataSetId(), request.getTargetDataSetId());
    }

    public DataSetController(DataSetService dsService, ObjectMapper jsonObjectMapper, ConcurrentModificationService concurrentModificationService, JpaDataSetService dataSetService, CompareService compare) {
        this.dsService = dsService;
        this.jsonObjectMapper = jsonObjectMapper;
        this.concurrentModificationService = concurrentModificationService;
        this.dataSetService = dataSetService;
        this.compare = compare;
    }
}

