/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetSnapshot;
import org.qubership.atp.dataset.versioning.model.ui.AttributeUiModel;
import org.qubership.atp.dataset.versioning.model.ui.DataSetUiModel;

@Value
public class DataSetListUiModel {
    private final UUID id;
    private final String name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<DataSetUiModel> dataSets = new LinkedList<DataSetUiModel>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<AttributeUiModel> attributes = new LinkedList<AttributeUiModel>();

    public DataSetListUiModel(DataSetListSnapshot snapshot, ModelsProvider modelsProvider) {
        this.id = snapshot.getId();
        this.name = snapshot.getName();
        for (DataSetSnapshot dataSet : snapshot.getDataSets()) {
            this.dataSets.add(new DataSetUiModel(dataSet, modelsProvider));
        }
        for (AttributeSnapshot attribute : snapshot.getAttributes()) {
            this.attributes.add(new AttributeUiModel(attribute, snapshot.getOverlaps(), modelsProvider));
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DataSetUiModel> getDataSets() {
        return this.dataSets;
    }

    public List<AttributeUiModel> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetListUiModel)) {
            return false;
        }
        DataSetListUiModel other = (DataSetListUiModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<DataSetUiModel> this$dataSets = this.getDataSets();
        List<DataSetUiModel> other$dataSets = other.getDataSets();
        if (this$dataSets == null ? other$dataSets != null : !((Object)this$dataSets).equals(other$dataSets)) {
            return false;
        }
        List<AttributeUiModel> this$attributes = this.getAttributes();
        List<AttributeUiModel> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetListUiModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<DataSetUiModel> $dataSets = this.getDataSets();
        result = result * 59 + ($dataSets == null ? 43 : ((Object)$dataSets).hashCode());
        List<AttributeUiModel> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "DataSetListUiModel(id=" + this.getId() + ", name=" + this.getName() + ", dataSets=" + this.getDataSets() + ", attributes=" + this.getAttributes() + ")";
    }
}

