/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.javers.core.metamodel.annotation.Entity;
import org.javers.core.metamodel.annotation.Id;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.dataset.versioning.model.domain.AttributeKeySnapshot;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetSnapshot;
import org.qubership.atp.dataset.versioning.service.changes.AttributeComparable;
import org.qubership.atp.dataset.versioning.service.changes.AttributeKeyComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;

@Entity
@TypeName(value="DataSetList")
public class DataSetListComparable {
    @Id
    private final UUID id;
    private final String name;
    private final Set<DataSetComparable> dataSets = new HashSet<DataSetComparable>();
    private final Set<AttributeComparable> attributes = new HashSet<AttributeComparable>();
    private final Set<AttributeKeyComparable> overlaps = new HashSet<AttributeKeyComparable>();

    public DataSetListComparable(DataSetListSnapshot snapshot) {
        this.id = snapshot.getId();
        this.name = snapshot.getName();
        for (DataSetSnapshot dataSet : snapshot.getDataSets()) {
            this.dataSets.add(new DataSetComparable(dataSet));
        }
        for (AttributeSnapshot attribute : snapshot.getAttributes()) {
            this.attributes.add(new AttributeComparable(attribute));
        }
        for (AttributeKeySnapshot overlap : snapshot.getOverlaps()) {
            this.overlaps.add(new AttributeKeyComparable(overlap));
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<DataSetComparable> getDataSets() {
        return this.dataSets;
    }

    public Set<AttributeComparable> getAttributes() {
        return this.attributes;
    }

    public Set<AttributeKeyComparable> getOverlaps() {
        return this.overlaps;
    }

    public String toString() {
        return "DataSetListComparable(id=" + this.getId() + ", name=" + this.getName() + ", dataSets=" + this.getDataSets() + ", attributes=" + this.getAttributes() + ", overlaps=" + this.getOverlaps() + ")";
    }
}

