/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class UpdateParameterProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(UpdateParameterProcessor.class);
    @Autowired
    ModelsProvider modelsProvider;

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ValueChange> valueChanges = UpdateParameterProcessor.filterChangesByTypeAndProperty(diff, ValueChange.class, "value");
        return !valueChanges.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ValueChange parameterValueChange = UpdateParameterProcessor.filterChangesByTypeAndProperty(diff, ValueChange.class, "value").get(0);
        ParameterComparable parameter = (ParameterComparable)parameterValueChange.getAffectedObject().get();
        String attributeName = UpdateParameterProcessor.getAttributeDeepNameByParameter(actualEntity.getAttributes(), parameter);
        String dataSetName = UpdateParameterProcessor.getDataSetById(actualEntity, parameter.getDataSet()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setAttribute(attributeName);
        historyItem.setDataSet(dataSetName);
        if (parameterValueChange.getLeft() != null) {
            historyItem.setOldValue(this.getValuePretty(parameterValueChange.getLeft().toString(), parameter.getType(), this.modelsProvider));
        }
        if (parameterValueChange.getRight() != null) {
            historyItem.setNewValue(this.getValuePretty(parameterValueChange.getRight().toString(), parameter.getType(), this.modelsProvider));
        }
        log.trace("Diff processed by UpdateParameterProcessor");
        return historyItem;
    }
}

