/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import java.util.List;
import org.javers.core.diff.Diff;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.ChangeProcessorsChain;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.ChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChangeProcessorsChainImpl
implements ChangeProcessorsChain {
    private static final Logger log = LoggerFactory.getLogger(ChangeProcessorsChainImpl.class);
    private ChangeProcessor firstChangeProcessor;

    public ChangeProcessorsChainImpl(List<ChangeProcessor> changeProcessors) {
        if (changeProcessors.isEmpty()) {
            throw new IllegalArgumentException("There are no ChangeProcessors");
        }
        this.firstChangeProcessor = changeProcessors.get(0);
        for (int i = 0; i < changeProcessors.size() - 1; ++i) {
            ChangeProcessor changeProcessor = changeProcessors.get(i);
            changeProcessor.setNextProcessor(changeProcessors.get(i + 1));
        }
    }

    @Override
    public HistoryItemDto proceed(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        return this.firstChangeProcessor.proceed(diff, oldEntity, actualEntity);
    }
}

