/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import clover.com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.javers.core.Javers;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.EntityNotFoundException;
import org.qubership.atp.dataset.service.rest.dto.versioning.UiManDataSetListJDto;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.model.ui.DataSetListUiModel;
import org.qubership.atp.dataset.versioning.service.RevisionDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RevisionDetailsServiceImpl
implements RevisionDetailsService {
    private static final Logger log = LoggerFactory.getLogger(RevisionDetailsServiceImpl.class);
    private final Javers javers;
    private final ModelsProvider modelsProvider;

    @Override
    public UiManDataSetListJDto getRevisionDetails(Integer revision, UUID entityId) {
        log.debug("RevisionDetailsServiceImpl#getRevisionDetails(revision={}, entityId={})", (Object)revision, (Object)entityId);
        Optional<Shadow<DataSetListSnapshot>> entity = this.getShadow(revision, entityId);
        Shadow<DataSetListSnapshot> shadow = entity.orElseThrow(() -> new EntityNotFoundException(String.format("Failed to found shadow with id=%s and revision=%s", entityId, revision)));
        UiManDataSetListJDto revisionDetails = this.buildResponse(shadow);
        log.debug("Revision details: {}", (Object)revisionDetails);
        return revisionDetails;
    }

    private UiManDataSetListJDto buildResponse(Shadow<DataSetListSnapshot> entity) {
        DataSetListSnapshot model = (DataSetListSnapshot)entity.get();
        log.debug("Shadow: {}", (Object)model);
        DataSetListUiModel uiModel = new DataSetListUiModel(model, this.modelsProvider);
        return new UiManDataSetListJDto().author(entity.getCommitMetadata().getAuthor()).name(uiModel.getName()).dataSets(Lists.newArrayList(uiModel.getDataSets())).attributes(Lists.newArrayList(uiModel.getAttributes()));
    }

    private Optional<Shadow<DataSetListSnapshot>> getShadow(Integer revision, UUID entityId) {
        JqlQuery query = this.getQuery(revision, entityId);
        List shadows = this.javers.findShadows(query);
        return shadows.stream().findFirst();
    }

    private JqlQuery getQuery(Integer revision, UUID entityId) {
        return QueryBuilder.byInstanceId((Object)entityId, DataSetListSnapshot.class).withScopeCommitDeep().withVersion(Long.valueOf(revision.intValue()).longValue()).build();
    }

    public RevisionDetailsServiceImpl(Javers javers, ModelsProvider modelsProvider) {
        this.javers = javers;
        this.modelsProvider = modelsProvider;
    }
}

