/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.SimpleObjectProvider;
import reactor.core.publisher.Flux;

public final class ServiceInstanceListSuppliers {
    private ServiceInstanceListSuppliers() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static ServiceInstanceListSupplier from(final String serviceId, final ServiceInstance ... instances) {
        return new ServiceInstanceListSupplier(){

            @Override
            public Flux<List<ServiceInstance>> get() {
                return Flux.just(Arrays.asList(instances));
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }
        };
    }

    public static ObjectProvider<ServiceInstanceListSupplier> toProvider(String serviceId, ServiceInstance ... instances) {
        return new SimpleObjectProvider<ServiceInstanceListSupplier>(ServiceInstanceListSuppliers.from(serviceId, instances));
    }
}

