/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.dataset.controllers.api.dto.testplans.DataSetListIdNameLabelsTestPlanViewDto;
import org.qubership.atp.dataset.controllers.api.dto.testplans.TestPlanDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="TestPlanController", description="Test Plan Controller")
public interface TestPlanControllerApi {
    @Operation(operationId="create", summary="Creates new Test Plan with name provided.", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/testplan/va/{vaId}"}, produces={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2);

    @Operation(operationId="delete", summary="Deletes Test Plan with provided name.", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/testplan/va/{vaId}"})
    public ResponseEntity<Void> delete(@Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var1, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var2);

    @Operation(operationId="getDataSetListsUnderTestPlan", summary="Returns dataSetLists with selected Test Plan", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DataSetListIdNameLabelsTestPlanViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/testplan/{testPlanId}/dsl"}, produces={"application/json"})
    public ResponseEntity<List<DataSetListIdNameLabelsTestPlanViewDto>> getDataSetListsUnderTestPlan(@Parameter(name="testPlanId", description="testPlanId", required=true) @PathVariable(value="testPlanId") UUID var1);

    @Operation(operationId="getTestPlans", summary="Returns all test plans for selected visibility area.", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/testplan/va/{vaId}"}, produces={"application/json"})
    public ResponseEntity<List<TestPlanDto>> getTestPlans(@Parameter(name="vaId", description="vaId", required=true) @PathVariable(value="vaId") UUID var1);
}

