/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.jpa.repositories;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.VisibilityAreaEntity;
import org.qubership.atp.dataset.db.jpa.repositories.JpaDataSetListRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaDataSetListRepository
extends JpaRepository<DataSetListEntity, UUID>,
JpaDataSetListRepositoryCustom {
    public List<DataSetListEntity> findByVisibilityArea(VisibilityAreaEntity var1);

    public List<DataSetListEntity> findByVisibilityAreaId(UUID var1);

    public List<DataSetListEntity> findAllByVisibilityAreaId(UUID var1);

    public Optional<DataSetListEntity> findById(UUID var1);

    public List<DataSetListEntity> getByNameAndVisibilityAreaId(String var1, UUID var2);

    public List<DataSetListEntity> getBySourceIdAndVisibilityAreaId(UUID var1, UUID var2);

    @Query(value="select cast(id as varchar) from dataset where datasetlist_id = :dsl_id order by ordering", nativeQuery=true)
    public LinkedList<UUID> getDataSetsIdsByDataSetListId(@Param(value="dsl_id") UUID var1);

    @Query(value="select distinct cast(datasetlist_id as varchar) from \"attribute\" where type_datasetlist_id in (:dsl_ids)", nativeQuery=true)
    public LinkedList<UUID> getAffectedDataSetListIdsByDataSetListId(@Param(value="dsl_ids") List<UUID> var1);

    @Query(value="select cast(id as varchar) from dataset where datasetlist_id in (:dsl_ids)", nativeQuery=true)
    public Set<UUID> getAffectedDataSetIdsByDataSetListId(@Param(value="dsl_ids") Set<UUID> var1);

    @Query(value="select distinct name from datasetlist dsl where (select count(*) from datasetlist  dsl2 where dsl2.name = dsl.name  and dsl2.visibility_area_id = dsl.visibility_area_id) > 1 and dsl.visibility_area_id  = ?1", nativeQuery=true)
    public List<String> getNotUniqueDslNames(UUID var1);

    @Query(value="select cast(id as varchar) from datasetlist where saga_session_id = :saga_session_id and visibility_area_id = :visibility_area_id", nativeQuery=true)
    public Set<UUID> findAllIdsBySagaSessionIdAndVisibilityAreaId(@Param(value="saga_session_id") UUID var1, @Param(value="visibility_area_id") UUID var2);
}

